/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;

@Internal
final class CharSequenceSerde
implements SerdeRegistrar<CharSequence> {
    CharSequenceSerde() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends CharSequence> type, CharSequence value) throws IOException {
        encoder.encodeString(value.toString());
    }

    @Override
    public CharSequence deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super CharSequence> type) throws IOException {
        return decoder.decodeString();
    }

    @Override
    public CharSequence deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super CharSequence> type) throws IOException {
        return decoder.decodeStringNullable();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, CharSequence value) {
        return value == null || value.isEmpty();
    }

    @Override
    public Argument<CharSequence> getType() {
        return Argument.of(CharSequence.class);
    }
}

