/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import java.io.IOException;

public final class CustomizedObjectArraySerializer
implements Serializer<Object[]> {
    private final Argument<Object> componentType;
    private final Serializer<Object> componentSerializer;

    public CustomizedObjectArraySerializer(Argument<Object> componentType, Serializer<Object> componentSerializer) {
        this.componentType = componentType;
        this.componentSerializer = componentSerializer;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Object[]> type, Object[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        int index = 0;
        for (Object v : value) {
            try {
                this.componentSerializer.serialize(arrayEncoder, context, this.componentType, v);
                ++index;
            }
            catch (SerdeException e) {
                e.getPath().add(ReferencePath.ofCollection(type.getType().componentType(), type, index));
                throw e;
            }
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, Object[] value) {
        return ArrayUtils.isEmpty(value);
    }
}

