/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class DoubleSerde
implements SerdeRegistrar<Double>,
NumberSerde<Double> {
    DoubleSerde() {
    }

    @Override
    public Double deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Double> type) throws IOException {
        return decoder.decodeDouble();
    }

    @Override
    public Double deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Double> type) throws IOException {
        return decoder.decodeDoubleNullable();
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Double> type, Double value) throws IOException {
        encoder.encodeDouble(value);
    }

    @Override
    public boolean isDefault(Serializer.EncoderContext context, Double value) {
        return value.equals(0.0);
    }

    @Override
    public Argument<Double> getType() {
        return Argument.of(Double.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.DOUBLE);
    }

    @Override
    @Nullable
    public Double getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Double> type) {
        return type.isPrimitive() ? Double.valueOf(0.0) : null;
    }
}

