/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.time.Duration;

@Internal
final class DurationSerde
implements SerdeRegistrar<Duration> {
    DurationSerde() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Duration> type, Duration value) throws IOException {
        encoder.encodeLong(value.toNanos());
    }

    @Override
    public Duration deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Duration> type) throws IOException {
        return Duration.ofNanos(decoder.decodeLong());
    }

    @Override
    public Argument<Duration> getType() {
        return Argument.of(Duration.class);
    }
}

