/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.OptionalInt;

@Internal
final class OptionalIntSerde
implements SerdeRegistrar<OptionalInt> {
    OptionalIntSerde() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalInt> type, OptionalInt value) throws IOException {
        if (value.isPresent()) {
            encoder.encodeInt(value.getAsInt());
        } else {
            encoder.encodeNull();
        }
    }

    @Override
    public OptionalInt deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super OptionalInt> type) throws IOException {
        if (decoder.decodeNull()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(decoder.decodeInt());
    }

    @Override
    public OptionalInt deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super OptionalInt> type) throws IOException {
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public OptionalInt getDefaultValue(Deserializer.DecoderContext context, Argument<? super OptionalInt> type) {
        return OptionalInt.empty();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, OptionalInt value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, OptionalInt value) {
        return value == null || value.isEmpty();
    }

    @Override
    public Argument<OptionalInt> getType() {
        return Argument.of(OptionalInt.class);
    }
}

