/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.util.CustomizableDeserializer;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Optional;

@Internal
final class OptionalSerde<T>
implements CustomizableSerializer<Optional<T>>,
CustomizableDeserializer<Optional<T>>,
SerdeRegistrar<Optional<T>> {
    OptionalSerde() {
    }

    @Override
    public Serializer<Optional<T>> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Optional<T>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty(generics)) {
            throw new SerdeException("Serializing raw optionals is not supported for type: " + String.valueOf(type));
        }
        Object generic2 = generics[0];
        final Serializer contentSerializer = encoderContext.findSerializer(generic2).createSpecific(encoderContext, generic2);
        SerdeConfig.SerInclude includeContent = type.getAnnotationMetadata().enumValue(SerdeConfig.class.getName(), "includeContent", SerdeConfig.SerInclude.class).orElse(SerdeConfig.SerInclude.ALWAYS);
        return new Serializer<Optional<T>>((Argument)generic2, includeContent){
            final /* synthetic */ Argument val$generic;
            final /* synthetic */ SerdeConfig.SerInclude val$includeContent;
            {
                this.val$generic = argument;
                this.val$includeContent = serInclude;
            }

            @Override
            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Optional<T>> type, Optional<T> value) throws IOException {
                Object o = value.orElse(null);
                if (o == null) {
                    encoder.encodeNull();
                } else {
                    contentSerializer.serialize(encoder, context, this.val$generic, o);
                }
            }

            @Override
            public boolean isEmpty(Serializer.EncoderContext context, Optional<T> value) {
                if (value == null || value.isEmpty()) {
                    return true;
                }
                if (this.val$includeContent == SerdeConfig.SerInclude.NON_EMPTY) {
                    return contentSerializer.isEmpty(context, value.get());
                }
                return false;
            }

            @Override
            public boolean isAbsent(Serializer.EncoderContext context, Optional<T> value) {
                if (value == null || value.isEmpty()) {
                    return true;
                }
                return switch (this.val$includeContent) {
                    case SerdeConfig.SerInclude.NON_ABSENT -> contentSerializer.isAbsent(context, value.get());
                    case SerdeConfig.SerInclude.NON_EMPTY -> contentSerializer.isEmpty(context, value.get());
                    default -> false;
                };
            }
        };
    }

    @Override
    public Deserializer<Optional<T>> createSpecific(Deserializer.DecoderContext context, Argument<? super Optional<T>> type) throws SerdeException {
        final Argument generic2 = type.getFirstTypeVariable().orElse(null);
        if (generic2 == null) {
            throw new SerdeException("Cannot deserialize raw optional");
        }
        final Deserializer deserializer = context.findDeserializer(generic2).createSpecific(context, generic2);
        return new Deserializer<Optional<T>>(){

            @Override
            public Optional<T> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Optional<T>> type) throws IOException {
                if (decoder.decodeNull()) {
                    return Optional.empty();
                }
                return Optional.ofNullable(deserializer.deserialize(decoder, context, generic2));
            }

            @Override
            public Optional<T> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Optional<T>> type) throws IOException {
                return this.deserialize(decoder, context, type);
            }

            @Override
            public Optional<T> getDefaultValue(Deserializer.DecoderContext context, Argument<? super Optional<T>> type) {
                return Optional.empty();
            }
        };
    }

    @Override
    public Argument<Optional<T>> getType() {
        return Argument.of(Optional.class, Argument.ofTypeVariable(Object.class, "T"));
    }
}

