/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.net.URI;

@Internal
final class URISerde
implements SerdeRegistrar<URI> {
    URISerde() {
    }

    @Override
    public Argument<URI> getType() {
        return Argument.of(URI.class);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends URI> type, URI value) throws IOException {
        encoder.encodeString(value.toString());
    }

    @Override
    public URI deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super URI> type) throws IOException {
        return URI.create(decoder.decodeString());
    }

    @Override
    public URI deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super URI> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }
}

