/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.support.util.JsonNodeEncoder;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Map;

@Internal
final class CustomizedMapSerializer<K, V>
implements CustomizableSerializer<Map<K, V>>,
SerializerRegistrar<Map<K, V>> {
    CustomizedMapSerializer() {
    }

    @Override
    public ObjectSerializer<Map<K, V>> createSpecific(Serializer.EncoderContext context, Argument<? extends Map<K, V>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        boolean hasGenerics = ArrayUtils.isNotEmpty(generics) && generics.length == 2;
        final SerdeConfig.SerInclude includeContent = type.getAnnotationMetadata().enumValue(SerdeConfig.class.getName(), "includeContent", SerdeConfig.SerInclude.class).orElse(SerdeConfig.SerInclude.ALWAYS);
        if (hasGenerics) {
            Object keyGeneric = generics[0];
            Serializer<K> keySerializer = this.findKeySerializer(context, (Argument<K>)keyGeneric);
            final boolean isStringKey = keyGeneric.getType().equals(String.class) || CharSequence.class.isAssignableFrom(keyGeneric.getType());
            Argument valueGeneric = SerdeArgumentConf.reconstructGenericWithParentMetadata(type, generics[1]);
            final Serializer valSerializer = context.findSerializer(valueGeneric).createSpecific(context, valueGeneric);
            return new ObjectSerializer<Map<K, V>>((Argument)keyGeneric, keySerializer, valueGeneric){
                final /* synthetic */ Argument val$keyGeneric;
                final /* synthetic */ Serializer val$keySerializer;
                final /* synthetic */ Argument val$valueGeneric;
                {
                    this.val$keyGeneric = argument;
                    this.val$keySerializer = serializer2;
                    this.val$valueGeneric = argument2;
                }

                @Override
                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    Encoder objectEncoder = encoder.encodeObject(type);
                    this.serializeInto(objectEncoder, context, type, value);
                    objectEncoder.finishStructure();
                }

                @Override
                public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    block7: for (Map.Entry entry : value.entrySet()) {
                        Object k = entry.getKey();
                        try {
                            Object v = entry.getValue();
                            switch (includeContent) {
                                case NON_ABSENT: {
                                    if (!valSerializer.isAbsent(context, v)) break;
                                    continue block7;
                                }
                                case NON_EMPTY: {
                                    if (!valSerializer.isEmpty(context, v)) break;
                                    continue block7;
                                }
                                case NON_NULL: {
                                    if (v != null) break;
                                    continue block7;
                                }
                            }
                            if (k == null) {
                                encoder.encodeNull();
                            } else if (isStringKey) {
                                encoder.encodeKey(k.toString());
                            } else {
                                CustomizedMapSerializer.this.encodeMapKey(context, encoder, this.val$keyGeneric, this.val$keySerializer, k);
                            }
                            if (v == null) {
                                encoder.encodeNull();
                                continue;
                            }
                            valSerializer.serialize(encoder, context, this.val$valueGeneric, v);
                        }
                        catch (SerdeException e) {
                            e.getPath().add(ReferencePath.ofMap(value.getClass(), type, k == null ? "<null>" : k.toString()));
                            throw e;
                        }
                    }
                }

                @Override
                public boolean isAbsent(Serializer.EncoderContext context, Map<K, V> value) {
                    return value == null;
                }

                @Override
                public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                    if (CollectionUtils.isEmpty(value)) {
                        return true;
                    }
                    if (includeContent != SerdeConfig.SerInclude.ALWAYS) {
                        block5: for (Object v : value.values()) {
                            switch (includeContent) {
                                case NON_ABSENT: {
                                    if (valSerializer.isAbsent(context, v)) continue block5;
                                    return false;
                                }
                                case NON_EMPTY: {
                                    if (valSerializer.isEmpty(context, v)) continue block5;
                                    return false;
                                }
                                case NON_NULL: {
                                    if (v == null) continue block5;
                                    return false;
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        return new ObjectSerializer<Map<K, V>>(){
            Argument<K> keyGeneric = null;
            Serializer<? super K> internalKeySerializer = null;
            Argument<V> valueGeneric = null;
            Serializer<? super V> internalValSerializer = null;

            @Override
            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                Encoder childEncoder = encoder.encodeObject(type);
                this.serializeInto(childEncoder, context, type, value);
                childEncoder.finishStructure();
            }

            @Override
            public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                for (Map.Entry entry : value.entrySet()) {
                    Object k = entry.getKey();
                    try {
                        if (k instanceof CharSequence) {
                            encoder.encodeKey(k.toString());
                        } else {
                            Serializer keySerializer = this.getKeySerializer(context, k);
                            CustomizedMapSerializer.this.encodeMapKey(context, encoder, this.keyGeneric, keySerializer, k);
                        }
                        Object v = entry.getValue();
                        if (v == null) {
                            encoder.encodeNull();
                            continue;
                        }
                        Serializer valSerializer = this.getValueSerializer(context, v);
                        valSerializer.serialize(encoder, context, this.valueGeneric, v);
                    }
                    catch (SerdeException e) {
                        e.getPath().add(ReferencePath.ofMap(value.getClass(), type, k.toString()));
                        throw e;
                    }
                }
            }

            private Serializer<? super K> getKeySerializer(Serializer.EncoderContext context, K k) throws SerdeException {
                if (this.keyGeneric == null || !this.keyGeneric.getType().equals(k.getClass())) {
                    this.keyGeneric = Argument.of(k.getClass());
                    this.internalKeySerializer = CustomizedMapSerializer.this.findKeySerializer(context, this.keyGeneric);
                }
                return this.internalKeySerializer;
            }

            private Serializer<? super V> getValueSerializer(Serializer.EncoderContext context, V v) throws SerdeException {
                if (this.valueGeneric == null || !this.valueGeneric.getType().equals(v.getClass())) {
                    this.valueGeneric = Argument.of(v.getClass());
                    this.internalValSerializer = context.findSerializer(this.valueGeneric).createSpecific(context, this.valueGeneric);
                }
                return this.internalValSerializer;
            }

            @Override
            public boolean isAbsent(Serializer.EncoderContext context, Map<K, V> value) {
                return value == null;
            }

            @Override
            public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                if (CollectionUtils.isEmpty(value)) {
                    return true;
                }
                if (includeContent != SerdeConfig.SerInclude.ALWAYS) {
                    block7: for (Object v : value.values()) {
                        try {
                            Serializer valueSerializer = this.getValueSerializer(context, v);
                            switch (includeContent) {
                                case NON_ABSENT: {
                                    if (valueSerializer.isAbsent(context, v)) continue block7;
                                    return false;
                                }
                                case NON_EMPTY: {
                                    if (valueSerializer.isEmpty(context, v)) continue block7;
                                    return false;
                                }
                                case NON_NULL: {
                                    if (v == null) continue block7;
                                    return false;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        catch (SerdeException e) {
                            return (Boolean)CustomizedMapSerializer.sneakyThrow(e);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private static <T extends Throwable, R> R sneakyThrow(Throwable t2) throws T {
        throw t2;
    }

    private Serializer<K> findKeySerializer(Serializer.EncoderContext context, Argument<K> keyGeneric) throws SerdeException {
        try {
            return context.findSerializer(keyGeneric).createSpecific(context, keyGeneric);
        }
        catch (SerdeException e) {
            if (e.getCause() instanceof IntrospectionException) {
                return (encoder, ctx, type, value) -> this.convertMapKeyToStringAndEncode(ctx, encoder, value);
            }
            throw e;
        }
    }

    private void encodeMapKey(Serializer.EncoderContext context, Encoder encoder, Argument<K> keyGeneric, Serializer<? super K> keySerializer, K k) throws IOException {
        JsonNodeEncoder keyEncoder = JsonNodeEncoder.create();
        try {
            keySerializer.serialize(keyEncoder, context, keyGeneric, k);
        }
        catch (SerdeException e) {
            if (e.getCause() instanceof IntrospectionException) {
                this.convertMapKeyToStringAndEncode(context, encoder, k);
                return;
            }
            throw e;
        }
        JsonNode keyNode = keyEncoder.getCompletedValue();
        if (keyNode.isString()) {
            encoder.encodeKey(keyNode.getStringValue());
        } else {
            if (keyNode.isNull()) {
                throw new SerdeException("Null key for a Map not allowed in JSON");
            }
            if (keyNode.isBoolean() || keyNode.isNumber()) {
                encoder.encodeKey(keyNode.coerceStringValue());
            } else {
                this.convertMapKeyToStringAndEncode(context, encoder, keyNode.getValue());
            }
        }
    }

    private void convertMapKeyToStringAndEncode(Serializer.EncoderContext context, Encoder encoder, Object keyValue) throws IOException {
        try {
            String result = context.getConversionService().convertRequired(keyValue, Argument.STRING);
            if (result == null) {
                throw new SerdeException("Null key for a Map not allowed in JSON");
            }
            encoder.encodeKey(result);
        }
        catch (ConversionErrorException ce) {
            throw new SerdeException("Error converting Map key [" + String.valueOf(keyValue) + "] to String: " + ce.getMessage(), ce);
        }
    }

    @Override
    public Argument<Map<K, V>> getType() {
        return Argument.mapOf(Argument.ofTypeVariable(Object.class, "K"), Argument.ofTypeVariable(Object.class, "V"));
    }
}

