/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.SerializationReference;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;

@Internal
final class CustomizedObjectSerializer<T>
implements ObjectSerializer<T> {
    private final SerBean<T> serBean;

    CustomizedObjectSerializer(SerBean<T> serBean) {
        this.serBean = serBean;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        Encoder childEncoder = encoder.encodeObject(type);
        this.serializeInto(childEncoder, context, type, value);
        childEncoder.finishStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        for (SerBean.SerProperty property : this.serBean.writeProperties) {
            try {
                SerializationReference ref;
                Object propertyValue = property.get(value);
                String backRef = property.backRef;
                if (backRef != null && (ref = context.resolveReference(new SerializationReference(backRef, this.serBean.introspection, property.argument, propertyValue, property.serializer))) == null) continue;
                Serializer<Object> serializer = property.serializer;
                if (this.serBean.propertyFilter != null) {
                    if (!this.serBean.propertyFilter.shouldInclude(context, serializer, value, property.name, propertyValue)) {
                        continue;
                    }
                } else {
                    boolean skipped;
                    if (skipped = (switch (property.include) {
                        default -> throw new IncompatibleClassChangeError();
                        case SerdeConfig.SerInclude.ALWAYS -> false;
                        case SerdeConfig.SerInclude.NON_NULL -> {
                            if (propertyValue == null) {
                                yield true;
                            }
                            yield false;
                        }
                        case SerdeConfig.SerInclude.NON_ABSENT -> serializer.isAbsent(context, propertyValue);
                        case SerdeConfig.SerInclude.NON_DEFAULT -> {
                            if (serializer.isEmpty(context, propertyValue) || propertyValue != null && serializer.isDefault(context, propertyValue)) {
                                yield true;
                            }
                            yield false;
                        }
                        case SerdeConfig.SerInclude.NON_EMPTY -> serializer.isEmpty(context, propertyValue);
                        case SerdeConfig.SerInclude.NEVER -> true;
                    })) continue;
                }
                if (property.views != null && !context.hasView(property.views)) continue;
                String managedRef = property.managedRef;
                if (managedRef != null) {
                    context.pushManagedRef(new SerializationReference(managedRef, this.serBean.introspection, property.argument, value, property.serializer));
                }
                try {
                    if (property.serializableInto) {
                        if (property.objectSerializer != null) {
                            property.objectSerializer.serializeInto(encoder, context, property.argument, propertyValue);
                            continue;
                        }
                        throw new SerdeException("Serializer for a property: " + property.name + " doesn't support serializing into an existing object");
                    }
                    encoder.encodeKey(property.name);
                    if (propertyValue == null) {
                        encoder.encodeNull();
                        continue;
                    }
                    serializer.serialize(encoder, context, property.argument, propertyValue);
                }
                finally {
                    if (managedRef == null) continue;
                    context.popManagedRef();
                }
            }
            catch (SerdeException e) {
                e.getPath().add(property.getReferencePath());
                throw e;
            }
            catch (Exception e) {
                SerdeException serdeException = new SerdeException("Error getting property [" + String.valueOf(property.argument) + "] of type [" + String.valueOf(property.beanType) + "]: " + e.getMessage(), e);
                serdeException.getPath().add(property.getReferencePath());
                throw serdeException;
            }
        }
    }
}

