/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.ErrorCatchingSerializer;
import java.io.IOException;

@Internal
final class ErrorCatchingObjectSerializer<T>
extends ErrorCatchingSerializer<T>
implements ObjectSerializer<T> {
    private final ObjectSerializer<T> serializer;

    ErrorCatchingObjectSerializer(ObjectSerializer<T> serializer) {
        super(serializer);
        this.serializer = serializer;
    }

    @Override
    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try {
            this.serializer.serializeInto(encoder, context, (Argument<? extends T>)type, (T)value);
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + String.valueOf(type), e);
        }
        catch (SerdeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath(), e);
        }
    }
}

