/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.support.serializers.CustomizedIterableSerializer;
import io.micronaut.serde.support.serializers.RuntimeValueIterableSerializer;
import io.micronaut.serde.support.serializers.StringIterableSerializer;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.util.CustomizableSerializer;

@Internal
final class IterableSerializer<T>
implements CustomizableSerializer<Iterable<T>>,
SerializerRegistrar<Iterable<T>> {
    IterableSerializer() {
    }

    @Override
    public Serializer<Iterable<T>> createSpecific(Serializer.EncoderContext context, Argument<? extends Iterable<T>> type) throws SerdeException {
        Argument[] generics = type.getTypeParameters();
        if (generics.length > 0) {
            Argument generic2 = SerdeArgumentConf.reconstructGenericWithParentMetadata(type, generics[0]);
            if (generic2.getType() == String.class) {
                return StringIterableSerializer.INSTANCE;
            }
            Serializer componentSerializer = context.findSerializer(generic2).createSpecific(context, generic2);
            return new CustomizedIterableSerializer(generic2, componentSerializer);
        }
        return new RuntimeValueIterableSerializer();
    }

    @Override
    public Argument<Iterable<T>> getType() {
        return Argument.of(Iterable.class, Argument.ofTypeVariable(Object.class, "T"));
    }
}

