/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
final class RuntimeTypeSerializer
implements ObjectSerializer<Object> {
    private final Serializer.EncoderContext encoderContext;
    private final Map<Class<?>, Serializer<Object>> inners = new ConcurrentHashMap(10);
    @Nullable
    private final Serializer<Object> outer;
    @Nullable
    private final IntrospectionException introspectionException;
    private final Argument<?> outerType;

    public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext, @Nullable Serializer<Object> outer, @Nullable IntrospectionException introspectionException, Argument<?> outerType) {
        this.encoderContext = encoderContext;
        this.outer = outer;
        this.introspectionException = introspectionException;
        this.outerType = outerType;
    }

    public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext, Serializer<Object> outer, Argument<?> type) {
        this(encoderContext, outer, null, type);
    }

    public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext, IntrospectionException introspectionException, Argument<?> type) {
        this(encoderContext, null, introspectionException, type);
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
        if (value == null) {
            encoder.encodeNull();
        } else {
            Serializer<Object> serializer;
            Class<?> t2 = value.getClass();
            if (this.outer != null && t2 == type.getType()) {
                serializer = this.outer;
            } else {
                type = Argument.of(t2);
                serializer = this.getSerializer(context, value);
            }
            serializer.serialize(encoder, context, type, value);
        }
    }

    @Override
    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
        Serializer<Object> serializer;
        Class<?> t2 = value.getClass();
        if (this.outer != null && t2 == type.getType()) {
            serializer = this.outer;
        } else {
            type = Argument.of(t2);
            serializer = this.getSerializer(context, value);
        }
        if (!(serializer instanceof ObjectSerializer)) {
            throw this.serializeIntoNotSupported(type);
        }
        ObjectSerializer objectSerializer = (ObjectSerializer)serializer;
        objectSerializer.serializeInto(encoder, context, type, value);
    }

    private SerdeException serializeIntoNotSupported(Argument<?> type) {
        return new SerdeException("Serializer for type: " + String.valueOf(type) + " doesn't support serializing into an existing object");
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, Object value) {
        if (value == null) {
            return true;
        }
        try {
            return this.getSerializer(context, value).isEmpty(context, value);
        }
        catch (SerdeException serdeException) {
            return ObjectSerializer.super.isEmpty(context, value);
        }
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, Object value) {
        if (value == null) {
            return true;
        }
        try {
            return this.getSerializer(context, value).isAbsent(context, value);
        }
        catch (SerdeException serdeException) {
            return ObjectSerializer.super.isAbsent(context, value);
        }
    }

    private Serializer<Object> getSerializer(Serializer.EncoderContext context, Object value) throws SerdeException {
        try {
            return this.inners.computeIfAbsent(value.getClass(), t2 -> {
                try {
                    if (value.getClass().equals(this.outerType.getType())) {
                        if (this.outer == null) {
                            throw new SerdeException(this.introspectionException.getMessage(), this.introspectionException);
                        }
                        return this.outer;
                    }
                    Argument<?> arg = Argument.of(value.getClass(), this.outerType.getAnnotationMetadata(), new Argument[0]);
                    return this.encoderContext.findSerializer(arg).createSpecific(context, arg);
                }
                catch (SerdeException ex) {
                    throw new IntrospectionException("No serializer found for type: " + String.valueOf(value.getClass()), ex);
                }
            });
        }
        catch (IntrospectionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof SerdeException) {
                SerdeException serdeException = (SerdeException)throwable;
                throw serdeException;
            }
            throw e;
        }
    }
}

