/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import java.io.IOException;
import java.util.Collection;

@Internal
final class StringIterableSerializer
implements Serializer<Iterable<String>> {
    static final StringIterableSerializer INSTANCE = new StringIterableSerializer();

    StringIterableSerializer() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Iterable<String>> type, Iterable<String> values) throws IOException {
        Encoder childEncoder = encoder.encodeArray(type);
        int index = 0;
        for (String value : values) {
            try {
                if (value == null) {
                    childEncoder.encodeNull();
                    continue;
                }
                childEncoder.encodeString(value);
                ++index;
            }
            catch (SerdeException e) {
                e.getPath().add(ReferencePath.ofCollection(values.getClass(), type, index));
                throw e;
            }
        }
        childEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, Iterable<String> value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return !value.iterator().hasNext();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, Iterable<String> value) {
        return value == null;
    }
}

