/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.bind.binders.PostponedRequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.UnmatchedRequestArgumentBinder;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.UnsafeExecutionHandle;
import io.micronaut.web.router.MethodBasedRouteInfo;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

abstract class AbstractRouteMatch<T, R>
implements MethodBasedRouteMatch<T, R> {
    protected final ConversionService conversionService;
    protected final MethodBasedRouteInfo<T, R> routeInfo;
    protected final MethodExecutionHandle<T, R> methodExecutionHandle;
    protected final UnsafeExecutionHandle<T, R> unsafeMethodExecutionHandle;
    protected final ExecutableMethod<T, R> executableMethod;
    private final Argument<?>[] arguments;
    private final String[] argumentNames;
    private final Object[] argumentValues;
    private final PostponedRequestArgumentBinder<Object>[] postponedArgumentBinders;
    private final PendingRequestBindingResult<?>[] pendingRequestBindingResults;
    private final boolean[] fulfilledArguments;
    private boolean fulfilled;
    private boolean beforeBindersApplied;
    private boolean afterBindersApplied;

    protected AbstractRouteMatch(MethodBasedRouteInfo<T, R> routeInfo, ConversionService conversionService) {
        this.routeInfo = routeInfo;
        this.conversionService = conversionService;
        this.methodExecutionHandle = routeInfo.getTargetMethod();
        this.executableMethod = this.methodExecutionHandle.getExecutableMethod();
        this.arguments = this.executableMethod.getArguments();
        this.argumentNames = routeInfo.getArgumentNames();
        int length = this.arguments.length;
        if (length == 0) {
            this.fulfilled = true;
            this.argumentValues = null;
            this.fulfilledArguments = null;
            this.postponedArgumentBinders = null;
            this.pendingRequestBindingResults = null;
        } else {
            this.argumentValues = new Object[length];
            this.fulfilledArguments = new boolean[length];
            this.postponedArgumentBinders = new PostponedRequestArgumentBinder[length];
            this.pendingRequestBindingResults = new PendingRequestBindingResult[length];
        }
        this.unsafeMethodExecutionHandle = this.methodExecutionHandle instanceof UnsafeExecutionHandle ? (UnsafeExecutionHandle)((Object)this.methodExecutionHandle) : null;
    }

    @Override
    public RouteInfo<R> getRouteInfo() {
        return this.routeInfo;
    }

    @Override
    public T getTarget() {
        return this.routeInfo.getTargetMethod().getTarget();
    }

    @Override
    @NonNull
    public ExecutableMethod<T, R> getExecutableMethod() {
        return this.executableMethod;
    }

    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.executableMethod.getAnnotationMetadata();
    }

    @Override
    public Optional<Argument<?>> getRequiredInput(String name) {
        for (int i = 0; i < this.argumentNames.length; ++i) {
            String argumentName = this.argumentNames[i];
            if (!name.equals(argumentName)) continue;
            return Optional.of(this.arguments[i]);
        }
        return Optional.empty();
    }

    @Override
    public boolean isFulfilled() {
        if (this.fulfilled) {
            return true;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            PendingRequestBindingResult<?> pendingRequestBindingResult;
            boolean isFulfilled = this.fulfilledArguments[i];
            if (isFulfilled || (pendingRequestBindingResult = this.pendingRequestBindingResults[i]) == null || pendingRequestBindingResult.isPending()) continue;
            Argument<?> argument = this.arguments[i];
            this.setBindingResult(i, argument, pendingRequestBindingResult);
            this.failOnConversionErrors(argument, pendingRequestBindingResult);
        }
        this.checkIfFulfilled();
        return this.fulfilled;
    }

    @Override
    public boolean isSatisfied(String name) {
        for (int i = 0; i < this.argumentNames.length; ++i) {
            String argumentName = this.argumentNames[i];
            if (!name.equals(argumentName)) continue;
            return this.fulfilledArguments[i];
        }
        return false;
    }

    @Override
    public Method getTargetMethod() {
        return this.routeInfo.getTargetMethod().getTargetMethod();
    }

    @Override
    public String getMethodName() {
        return this.executableMethod.getMethodName();
    }

    @Override
    public Class<T> getDeclaringType() {
        return this.executableMethod.getDeclaringType();
    }

    @Override
    public Argument<?>[] getArguments() {
        return this.executableMethod.getArguments();
    }

    @Override
    public ReturnType<R> getReturnType() {
        return this.executableMethod.getReturnType();
    }

    @Override
    public R invoke(Object ... arguments) {
        Argument<?>[] targetArguments = this.getArguments();
        if (targetArguments.length == 0) {
            return this.methodExecutionHandle.invoke(new Object[0]);
        }
        ArrayList argumentList = new ArrayList(arguments.length);
        Map<String, Object> variables = this.getVariableValues();
        Iterator<Object> valueIterator = variables.values().iterator();
        int i = 0;
        for (Argument<?> targetArgument : targetArguments) {
            Optional result;
            String name = targetArgument.getName();
            Object value = variables.get(name);
            if (value != null) {
                result = this.conversionService.convert(value, targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + String.valueOf(this.executableMethod))));
                continue;
            }
            if (valueIterator.hasNext()) {
                result = this.conversionService.convert(valueIterator.next(), targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + String.valueOf(this.executableMethod))));
                continue;
            }
            if (i < arguments.length) {
                result = this.conversionService.convert(arguments[i++], targetArgument.getType());
                argumentList.add(result.orElseThrow(() -> new IllegalArgumentException("Wrong argument types to method: " + String.valueOf(this.executableMethod))));
                continue;
            }
            throw new IllegalArgumentException("Wrong number of arguments to method: " + String.valueOf(this.executableMethod));
        }
        return this.methodExecutionHandle.invoke(argumentList.toArray());
    }

    @Override
    public R execute() {
        Argument<?>[] targetArguments = this.getArguments();
        if (targetArguments.length == 0) {
            if (this.unsafeMethodExecutionHandle != null) {
                return this.unsafeMethodExecutionHandle.invokeUnsafe(new Object[0]);
            }
            return this.methodExecutionHandle.invoke(new Object[0]);
        }
        if (this.fulfilled) {
            if (this.unsafeMethodExecutionHandle != null) {
                return this.unsafeMethodExecutionHandle.invokeUnsafe(this.argumentValues);
            }
            return this.methodExecutionHandle.invoke(this.argumentValues);
        }
        if (!this.beforeBindersApplied) {
            throw new IllegalStateException("Argument binders before filters not processed!");
        }
        if (!this.afterBindersApplied) {
            throw new IllegalStateException("Argument binders after filters not processed!");
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.fulfilledArguments[i]) continue;
            PendingRequestBindingResult<?> pendingRequestBindingResult = this.pendingRequestBindingResults[i];
            Argument<?> argument = this.arguments[i];
            if (pendingRequestBindingResult != null) {
                this.setBindingResultOfFail(i, argument, pendingRequestBindingResult);
                continue;
            }
            Object value = this.getVariableValues().get(this.argumentNames[i]);
            if (value != null) {
                this.setValue(i, argument, value);
                continue;
            }
            if (argument.isOptional()) {
                this.setValue(i, argument, Optional.empty());
                continue;
            }
            if (argument.isNullable()) continue;
            throw UnsatisfiedRouteException.create(argument);
        }
        if (this.methodExecutionHandle instanceof UnsafeExecutionHandle) {
            UnsafeExecutionHandle unsafeExecutionHandle = (UnsafeExecutionHandle)((Object)this.methodExecutionHandle);
            return unsafeExecutionHandle.invokeUnsafe(this.argumentValues);
        }
        return this.methodExecutionHandle.invoke(this.argumentValues);
    }

    @Override
    public void fulfill(Map<String, Object> newValues) {
        if (this.fulfilled) {
            return;
        }
        for (int i = 0; i < this.argumentNames.length; ++i) {
            String argumentName;
            Object value;
            if (this.fulfilledArguments[i] || (value = newValues.get(argumentName = this.argumentNames[i])) == null) continue;
            this.setValue(i, this.arguments[i], value);
        }
        this.checkIfFulfilled();
    }

    @Override
    public void fulfillBeforeFilters(RequestBinderRegistry requestBinderRegistry, HttpRequest<?> request) {
        if (this.fulfilled) {
            return;
        }
        if (this.beforeBindersApplied) {
            throw new IllegalStateException("Argument before filters already processed!");
        }
        RequestArgumentBinder<Object>[] argumentBinders = this.routeInfo.resolveArgumentBinders(requestBinderRegistry);
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.fulfilledArguments[i]) continue;
            Argument<?> argument = this.arguments[i];
            Object value = this.getVariableValues().get(this.argumentNames[i]);
            if (value != null) {
                this.setValue(i, argument, value);
                continue;
            }
            RequestArgumentBinder<Object> argumentBinder = argumentBinders[i];
            if (argumentBinder instanceof PostponedRequestArgumentBinder) {
                PostponedRequestArgumentBinder postponedRequestArgumentBinder;
                this.postponedArgumentBinders[i] = postponedRequestArgumentBinder = (PostponedRequestArgumentBinder)argumentBinder;
                if (!(argumentBinder instanceof UnmatchedRequestArgumentBinder)) continue;
            }
            if (argumentBinder == null) continue;
            this.fulfillValue(i, argumentBinder, argument, request);
        }
        this.checkIfFulfilled();
        this.beforeBindersApplied = true;
    }

    @Override
    public void fulfillAfterFilters(RequestBinderRegistry requestBinderRegistry, HttpRequest<?> request) {
        if (this.fulfilled) {
            return;
        }
        if (this.afterBindersApplied) {
            throw new IllegalStateException("Argument binders after filters already processed!");
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.fulfilledArguments[i]) continue;
            Argument<?> argument = this.arguments[i];
            PostponedRequestArgumentBinder<Object> argumentBinder = this.postponedArgumentBinders[i];
            if (argumentBinder == null) continue;
            this.fulfillValuePostponed(i, argumentBinder, argument, request);
        }
        this.checkIfFulfilled();
        this.afterBindersApplied = true;
    }

    private <E> void fulfillValue(int index, RequestArgumentBinder<E> argumentBinder, Argument<E> argument, HttpRequest<?> request) {
        ArgumentConversionContext<E> conversionContext = this.newContext(argument, request);
        ArgumentBinder.BindingResult<E> bindingResult = argumentBinder.bind(conversionContext, request);
        this.fulfillValue(index, argument, bindingResult);
    }

    private <E> void fulfillValuePostponed(int index, PostponedRequestArgumentBinder<E> argumentBinder, Argument<E> argument, HttpRequest<?> request) {
        ArgumentConversionContext<E> conversionContext = this.newContext(argument, request);
        ArgumentBinder.BindingResult<E> bindingResult = argumentBinder.bindPostponed(conversionContext, request);
        this.fulfillValue(index, argument, bindingResult);
    }

    private <E> ArgumentConversionContext<E> newContext(Argument<E> argument, HttpRequest<?> request) {
        return ConversionContext.of(argument, request.getLocale().orElse(null), request.getCharacterEncoding());
    }

    private <E> void fulfillValue(int index, Argument<E> argument, ArgumentBinder.BindingResult<E> bindingResult) {
        if (bindingResult instanceof PendingRequestBindingResult) {
            PendingRequestBindingResult pendingRequestBindingResult;
            this.pendingRequestBindingResults[index] = pendingRequestBindingResult = (PendingRequestBindingResult)bindingResult;
            return;
        }
        this.failOnConversionErrors(argument, bindingResult);
        this.setBindingResult(index, argument, bindingResult);
    }

    private void setBindingResultOfFail(int index, Argument<?> argument, ArgumentBinder.BindingResult<?> bindingResult) {
        boolean isSet = this.setBindingResult(index, argument, bindingResult);
        this.failOnConversionErrors(argument, bindingResult);
        if (isSet) {
            return;
        }
        if (argument.isNullable()) {
            this.setValue(index, argument, null);
            return;
        }
        if (argument.isOptional()) {
            this.setValue(index, argument, Optional.empty());
            return;
        }
        throw UnsatisfiedRouteException.create(argument);
    }

    private void failOnConversionErrors(Argument<?> argument, ArgumentBinder.BindingResult<?> bindingResult) {
        List<ConversionError> conversionErrors = bindingResult.getConversionErrors();
        if (!conversionErrors.isEmpty()) {
            ConversionError conversionError = conversionErrors.iterator().next();
            throw new ConversionErrorException(argument, conversionError);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setBindingResult(int index, Argument<?> argument, ArgumentBinder.BindingResult<?> bindingResult) {
        Object value;
        if (!bindingResult.isSatisfied()) {
            return false;
        }
        if (argument.getType() == Optional.class) {
            Optional<?> optionalValue = bindingResult.getValue();
            if (!optionalValue.isPresent()) return false;
            value = optionalValue.get();
        } else {
            if (!bindingResult.isPresentAndSatisfied()) return false;
            value = bindingResult.get();
        }
        this.setValue(index, argument, value);
        return true;
    }

    private void setValue(int index, Argument<?> argument, Object value) {
        if (value != null) {
            this.argumentValues[index] = this.convertValue(this.conversionService, argument, value);
        }
        this.fulfilledArguments[index] = true;
    }

    private void checkIfFulfilled() {
        if (this.fulfilled) {
            return;
        }
        for (boolean isFulfilled : this.fulfilledArguments) {
            if (isFulfilled) continue;
            return;
        }
        this.fulfilled = true;
    }

    private Object convertValue(ConversionService conversionService, Argument<?> argument, Object value) {
        if (value instanceof ConversionError) {
            ConversionError conversionError = (ConversionError)value;
            throw new ConversionErrorException(argument, conversionError);
        }
        Class argumentType = argument.getType();
        if (argumentType.isInstance(value)) {
            if (argument.isContainerType() && argument.hasTypeVariables()) {
                ArgumentConversionContext<?> conversionContext = ConversionContext.of(argument);
                Optional result = conversionService.convert(value, argumentType, conversionContext);
                return this.resolveValueOrError(argument, conversionContext, result);
            }
            return value;
        }
        ArgumentConversionContext<?> conversionContext = ConversionContext.of(argument);
        Optional result = conversionService.convert(value, argumentType, conversionContext);
        return this.resolveValueOrError(argument, conversionContext, result);
    }

    private Object resolveValueOrError(Argument<?> argument, ConversionContext conversionContext, Optional<?> result) {
        if (result.isEmpty()) {
            Optional<ConversionError> lastError = conversionContext.getLastError();
            if (lastError.isEmpty() && argument.isDeclaredNullable()) {
                return null;
            }
            throw lastError.map(conversionError -> new ConversionErrorException((Argument)argument, (ConversionError)conversionError)).orElseGet(() -> UnsatisfiedRouteException.create(argument));
        }
        return result.get();
    }
}

