/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.web.router.AbstractRouteMatch;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.UriRouteMatch;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

@Internal
public final class DefaultUriRouteMatch<T, R>
extends AbstractRouteMatch<T, R>
implements UriRouteMatch<T, R> {
    private final UriMatchInfo matchInfo;
    private final UriRouteInfo<T, R> uriRouteInfo;
    private final Charset defaultCharset;
    private Map<String, Object> variables;

    DefaultUriRouteMatch(UriMatchInfo matchInfo, UriRouteInfo<T, R> routeInfo, Charset defaultCharset, ConversionService conversionService) {
        super(routeInfo, conversionService);
        this.matchInfo = matchInfo;
        this.uriRouteInfo = routeInfo;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public String getUri() {
        return this.matchInfo.getUri();
    }

    @Override
    public Map<String, Object> getVariableValues() {
        if (this.variables == null) {
            Map<String, Object> matchVariables = this.matchInfo.getVariableValues();
            if (CollectionUtils.isNotEmpty(matchVariables)) {
                this.variables = CollectionUtils.newLinkedHashMap(matchVariables.size());
                matchVariables.forEach((k, v) -> {
                    if (v instanceof CharSequence) {
                        v = URLDecoder.decode(v.toString(), this.defaultCharset);
                    }
                    this.variables.put((String)k, v);
                });
            } else {
                this.variables = Map.of();
            }
        }
        return this.variables;
    }

    @Override
    public List<UriMatchVariable> getVariables() {
        return this.matchInfo.getVariables();
    }

    @Override
    public Map<String, UriMatchVariable> getVariableMap() {
        return this.matchInfo.getVariableMap();
    }

    @Override
    public UriRouteInfo<T, R> getRouteInfo() {
        return this.uriRouteInfo;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.uriRouteInfo.getHttpMethod();
    }

    public String toString() {
        return String.valueOf(this.uriRouteInfo.getHttpMethod()) + " - " + this.matchInfo.getUri();
    }
}

