/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.naming;

import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.TypeConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.web.router.RouteBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class HyphenatedUriNamingStrategy
implements RouteBuilder.UriNamingStrategy {
    private final String contextPath;

    public HyphenatedUriNamingStrategy() {
        this(null);
    }

    @Inject
    public HyphenatedUriNamingStrategy(@Nullable @Value(value="${micronaut.server.context-path}") String contextPath) {
        if (contextPath == null) {
            contextPath = "";
        }
        this.contextPath = HyphenatedUriNamingStrategy.normalizeContextPath(contextPath);
    }

    @Override
    public String resolveUri(Class<?> type) {
        return this.contextPath + "/" + TypeConvention.CONTROLLER.asHyphenatedName(type);
    }

    @Override
    @NonNull
    public String resolveUri(BeanDefinition<?> beanDefinition) {
        String uri = beanDefinition.stringValue(UriMapping.class).orElseGet(() -> beanDefinition.stringValue(Controller.class).orElse("/"));
        return this.contextPath + this.normalizeUri(uri);
    }

    @Override
    @NonNull
    public String resolveUri(String property) {
        if (StringUtils.isEmpty(property)) {
            return this.contextPath + "/";
        }
        if (property.charAt(0) != '/') {
            return this.contextPath + "/" + NameUtils.hyphenate(property, true);
        }
        return this.contextPath + property;
    }

    static String normalizeContextPath(String contextPath) {
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (((String)contextPath).charAt(0) != '/') {
                contextPath = "/" + (String)contextPath;
            }
            if (((String)contextPath).charAt(((String)contextPath).length() - 1) == '/') {
                contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
            }
        }
        return contextPath;
    }
}

