/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.model.Container;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ComposeCommand;
import org.testcontainers.containers.ComposeDelegate;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class ComposeContainer
extends FailureDetectingExternalResource
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(ComposeContainer.class);
    private final Map<String, Integer> scalingPreferences = new HashMap<String, Integer>();
    private boolean localCompose;
    private boolean pull = true;
    private boolean build = false;
    private Set<String> options = new HashSet<String>();
    private boolean tailChildContainers;
    private static final Object MUTEX = new Object();
    private List<String> services = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private RemoveImages removeImages;
    private boolean removeVolumes = true;
    public static final String COMPOSE_EXECUTABLE = SystemUtils.IS_OS_WINDOWS ? "docker.exe" : "docker";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("docker:24.0.2");
    private final ComposeDelegate composeDelegate;
    private String project;
    private List<String> filesInDirectory = new ArrayList<String>();

    public ComposeContainer(File ... composeFiles) {
        this(Arrays.asList(composeFiles));
    }

    public ComposeContainer(List<File> composeFiles) {
        this(Base58.randomString(6).toLowerCase(), composeFiles);
    }

    public ComposeContainer(String identifier, File ... composeFiles) {
        this(identifier, Arrays.asList(composeFiles));
    }

    public ComposeContainer(String identifier, List<File> composeFiles) {
        this.composeDelegate = new ComposeDelegate(ComposeDelegate.ComposeVersion.V2, composeFiles, identifier, COMPOSE_EXECUTABLE, DEFAULT_IMAGE_NAME);
        this.project = this.composeDelegate.getProject();
    }

    @Override
    @Deprecated
    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    @Override
    @Deprecated
    public void starting(Description description) {
        this.start();
    }

    @Override
    @Deprecated
    protected void succeeded(Description description) {
    }

    @Override
    @Deprecated
    protected void failed(Throwable e, Description description) {
    }

    @Override
    @Deprecated
    public void finished(Description description) {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = MUTEX;
        synchronized (object) {
            this.composeDelegate.registerContainersForShutdown();
            if (this.pull) {
                try {
                    this.composeDelegate.pullImages();
                }
                catch (ContainerLaunchException e) {
                    log.warn("Exception while pulling images, using local images if available", e);
                }
            }
            this.composeDelegate.createServices(this.localCompose, this.build, this.options, this.services, this.scalingPreferences, this.env, this.filesInDirectory);
            this.composeDelegate.startAmbassadorContainer();
            this.composeDelegate.waitUntilServiceStarted(this.tailChildContainers);
        }
    }

    @VisibleForTesting
    List<Container> listChildContainers() {
        return this.composeDelegate.listChildContainers();
    }

    public ComposeContainer withServices(String ... services) {
        if (services == null) {
            throw new NullPointerException("services is marked non-null but is null");
        }
        this.services = Arrays.asList(services);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = MUTEX;
        synchronized (object) {
            try {
                this.composeDelegate.getAmbassadorContainer().stop();
                String cmd = ComposeCommand.getDownCommand(ComposeDelegate.ComposeVersion.V2, this.options);
                if (this.removeVolumes) {
                    cmd = cmd + " -v";
                }
                if (this.removeImages != null) {
                    cmd = cmd + " --rmi " + this.removeImages.dockerRemoveImagesType();
                }
                this.composeDelegate.runWithCompose(this.localCompose, cmd, this.env, this.filesInDirectory);
            }
            finally {
                this.composeDelegate.clear();
                this.project = this.composeDelegate.randomProjectId();
            }
        }
    }

    public ComposeContainer withExposedService(String serviceName, int servicePort) {
        this.composeDelegate.withExposedService(serviceName, servicePort, Wait.defaultWaitStrategy());
        return this;
    }

    public ComposeContainer withExposedService(String serviceName, int instance, int servicePort) {
        return this.withExposedService(serviceName + "-" + instance, servicePort);
    }

    public ComposeContainer withExposedService(String serviceName, int instance, int servicePort, WaitStrategy waitStrategy) {
        this.composeDelegate.withExposedService(serviceName + "-" + instance, servicePort, waitStrategy);
        return this;
    }

    public ComposeContainer withExposedService(String serviceName, int servicePort, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        this.composeDelegate.withExposedService(serviceName, servicePort, waitStrategy);
        return this;
    }

    public ComposeContainer waitingFor(String serviceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        String serviceInstanceName = this.composeDelegate.getServiceInstanceName(serviceName);
        this.composeDelegate.addWaitStrategy(serviceInstanceName, waitStrategy);
        return this;
    }

    public String getServiceHost(String serviceName, Integer servicePort) {
        return this.composeDelegate.getServiceHost();
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        return this.composeDelegate.getServicePort(serviceName, servicePort);
    }

    public ComposeContainer withScaledService(String serviceBaseName, int numInstances) {
        this.scalingPreferences.put(serviceBaseName, numInstances);
        return this;
    }

    public ComposeContainer withEnv(String key, String value) {
        this.env.put(key, value);
        return this;
    }

    public ComposeContainer withEnv(Map<String, String> env) {
        env.forEach(this.env::put);
        return this;
    }

    public ComposeContainer withLocalCompose(boolean localCompose) {
        this.localCompose = localCompose;
        return this;
    }

    public ComposeContainer withPull(boolean pull) {
        this.pull = pull;
        return this;
    }

    public ComposeContainer withTailChildContainers(boolean tailChildContainers) {
        this.tailChildContainers = tailChildContainers;
        return this;
    }

    public ComposeContainer withLogConsumer(String serviceName, Consumer<OutputFrame> consumer) {
        this.composeDelegate.withLogConsumer(serviceName, consumer);
        return this;
    }

    public ComposeContainer withBuild(boolean build) {
        this.build = build;
        return this;
    }

    public ComposeContainer withOptions(String ... options) {
        this.options = new HashSet<String>(Arrays.asList(options));
        return this;
    }

    public ComposeContainer withRemoveImages(RemoveImages removeImages) {
        this.removeImages = removeImages;
        return this;
    }

    public ComposeContainer withRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
        return this;
    }

    public ComposeContainer withStartupTimeout(Duration startupTimeout) {
        this.composeDelegate.setStartupTimeout(startupTimeout);
        return this;
    }

    public ComposeContainer withCopyFilesInContainer(String ... fileCopyInclusions) {
        this.filesInDirectory = Arrays.asList(fileCopyInclusions);
        return this;
    }

    public Optional<ContainerState> getContainerByServiceName(String serviceName) {
        return this.composeDelegate.getContainerByServiceName(serviceName);
    }

    private void followLogs(String containerId, Consumer<OutputFrame> consumer) {
        this.followLogs(containerId, consumer);
    }

    public static enum RemoveImages {
        ALL("all"),
        LOCAL("local");

        private final String dockerRemoveImagesType;

        private RemoveImages(String dockerRemoveImagesType) {
            this.dockerRemoveImagesType = dockerRemoveImagesType;
        }

        public String dockerRemoveImagesType() {
            return this.dockerRemoveImagesType;
        }
    }
}

