/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Objects;

public interface NettyHttpResponseBuilder {
    @NonNull
    public FullHttpResponse toFullHttpResponse();

    @NonNull
    default public StreamedHttpResponse toStreamHttpResponse() {
        FullHttpResponse fullHttpResponse = this.toFullHttpResponse();
        DefaultStreamedHttpResponse streamedHttpResponse = new DefaultStreamedHttpResponse(fullHttpResponse.protocolVersion(), fullHttpResponse.status(), true, Publishers.just(new DefaultLastHttpContent(fullHttpResponse.content())));
        streamedHttpResponse.headers().setAll(fullHttpResponse.headers());
        return streamedHttpResponse;
    }

    @NonNull
    default public io.netty.handler.codec.http.HttpResponse toHttpResponse() {
        if (this.isStream()) {
            return this.toStreamHttpResponse();
        }
        return this.toFullHttpResponse();
    }

    public boolean isStream();

    @NonNull
    public static io.netty.handler.codec.http.HttpResponse toHttpResponse(@NonNull HttpResponse<?> response) {
        io.netty.handler.codec.http.HttpResponse fullHttpResponse;
        Objects.requireNonNull(response, "The response cannot be null");
        while (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            response = wrapper.getDelegate();
        }
        if (response instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)((Object)response);
            fullHttpResponse = builder.toHttpResponse();
        } else {
            ByteBuf byteBuf = response.getBody(ByteBuf.class).orElse(null);
            fullHttpResponse = byteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(response.code(), response.reason()), byteBuf) : new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(response.code(), response.reason()));
            response.getHeaders().forEach((s, strings) -> fullHttpResponse.headers().add((String)s, (Iterable<?>)strings));
        }
        return fullHttpResponse;
    }

    @NonNull
    public static StreamedHttpResponse toStreamResponse(@NonNull HttpResponse<?> response) {
        Objects.requireNonNull(response, "The response cannot be null");
        while (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            response = wrapper.getDelegate();
        }
        if (response instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)((Object)response);
            if (builder.isStream()) {
                return builder.toStreamHttpResponse();
            }
            FullHttpResponse fullHttpResponse = builder.toFullHttpResponse();
            return new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(response.code(), response.reason()), Publishers.just(new DefaultLastHttpContent(fullHttpResponse.content())));
        }
        ByteBuf byteBuf = response.getBody(ByteBuf.class).orElse(null);
        DefaultStreamedHttpResponse fullHttpResponse = byteBuf != null ? new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(response.code(), response.reason()), Publishers.just(new DefaultLastHttpContent(byteBuf))) : new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(response.code(), response.reason()), Publishers.empty());
        response.getHeaders().forEach((s, strings) -> fullHttpResponse.headers().add((String)s, (Iterable<?>)strings));
        return fullHttpResponse;
    }
}

