/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.cors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ImmutableArgumentConversionContext;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.cors.CorsOriginConfiguration;
import io.micronaut.http.server.cors.CorsUtil;
import io.micronaut.http.server.cors.CrossOriginUtil;
import io.micronaut.http.server.util.HttpHostResolver;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerFilter(value={"/**"})
public class CorsFilter
implements Ordered {
    public static final int CORS_FILTER_ORDER = ServerFilterPhase.METRICS.after();
    private static final Logger LOG = LoggerFactory.getLogger(CorsFilter.class);
    private static final ArgumentConversionContext<HttpMethod> CONVERSION_CONTEXT_HTTP_METHOD = ImmutableArgumentConversionContext.of(HttpMethod.class);
    protected final HttpServerConfiguration.CorsConfiguration corsConfiguration;
    @Nullable
    private final HttpHostResolver httpHostResolver;

    public CorsFilter(HttpServerConfiguration.CorsConfiguration corsConfiguration, @Nullable HttpHostResolver httpHostResolver) {
        this.corsConfiguration = corsConfiguration;
        this.httpHostResolver = httpHostResolver;
    }

    @RequestFilter
    @Nullable
    @Internal
    public final HttpResponse<?> filterRequest(HttpRequest<?> request) {
        String origin = request.getOrigin().orElse(null);
        if (origin == null) {
            LOG.trace("Http Header Origin not present. Proceeding with the request.");
            return null;
        }
        CorsOriginConfiguration corsOriginConfiguration = this.getConfiguration(request).orElse(null);
        if (corsOriginConfiguration != null) {
            if (CorsUtil.isPreflightRequest(request)) {
                return this.handlePreflightRequest(request, corsOriginConfiguration);
            }
            if (!this.validateMethodToMatch(request, corsOriginConfiguration).isPresent()) {
                return CorsFilter.forbidden();
            }
            if (this.shouldDenyToPreventDriveByLocalhostAttack(corsOriginConfiguration, request)) {
                LOG.trace("The resolved configuration allows any origin. To prevent drive-by-localhost attacks the request is forbidden");
                return CorsFilter.forbidden();
            }
            return null;
        }
        if (this.shouldDenyToPreventDriveByLocalhostAttack(origin, request)) {
            LOG.trace("the request specifies an origin different than localhost. To prevent drive-by-localhost attacks the request is forbidden");
            return CorsFilter.forbidden();
        }
        LOG.trace("CORS configuration not found for {} origin", (Object)origin);
        return null;
    }

    @ResponseFilter
    @Internal
    public final void filterResponse(HttpRequest<?> request, MutableHttpResponse<?> response) {
        CorsOriginConfiguration corsOriginConfiguration = this.getConfiguration(request).orElse(null);
        if (corsOriginConfiguration != null) {
            if (CorsUtil.isPreflightRequest(request)) {
                this.decorateResponseWithHeadersForPreflightRequest(request, response, corsOriginConfiguration);
            }
            this.decorateResponseWithHeaders(request, response, corsOriginConfiguration);
        }
    }

    protected boolean shouldDenyToPreventDriveByLocalhostAttack(@NonNull CorsOriginConfiguration corsOriginConfiguration, @NonNull HttpRequest<?> request) {
        if (this.corsConfiguration.isLocalhostPassThrough()) {
            return false;
        }
        if (this.httpHostResolver == null) {
            return false;
        }
        String origin = request.getOrigin().orElse(null);
        if (origin == null) {
            return false;
        }
        if (this.isOriginLocal(origin)) {
            return false;
        }
        String host = this.httpHostResolver.resolve(request);
        return CorsFilter.isAny(corsOriginConfiguration.getAllowedOrigins()) && this.isHostLocal(host);
    }

    protected boolean shouldDenyToPreventDriveByLocalhostAttack(@NonNull String origin, @NonNull HttpRequest<?> request) {
        if (this.corsConfiguration.isLocalhostPassThrough()) {
            return false;
        }
        if (this.httpHostResolver == null) {
            return false;
        }
        String host = this.httpHostResolver.resolve(request);
        return !this.isOriginLocal(origin) && this.isHostLocal(host);
    }

    private boolean isHostLocal(@NonNull String hostString) {
        if (hostString.isEmpty()) {
            return false;
        }
        char initialChar = hostString.charAt(0);
        if (initialChar != 'h' && initialChar != 'w') {
            return false;
        }
        return hostString.startsWith("http://localhost") || hostString.startsWith("https://localhost") || hostString.startsWith("http://127.") || hostString.startsWith("https://127.") || hostString.startsWith("ws://localhost") || hostString.startsWith("wss://localhost") || hostString.startsWith("ws://127.") || hostString.startsWith("wss://127.");
    }

    private boolean isOriginLocal(@NonNull String hostString) {
        try {
            URI uri = URI.create(hostString);
            String host = uri.getHost();
            return "localhost".equals(host) || "127.0.0.1".equals(host);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public int getOrder() {
        return CORS_FILTER_ORDER;
    }

    @NonNull
    private Optional<HttpMethod> validateMethodToMatch(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        HttpMethod methodToMatch = this.methodToMatch(request);
        if (!this.methodAllowed(config, methodToMatch)) {
            return Optional.empty();
        }
        return Optional.of(methodToMatch);
    }

    protected void setAllowCredentials(CorsOriginConfiguration config, MutableHttpResponse<?> response) {
        if (config.isAllowCredentials()) {
            response.header("Access-Control-Allow-Credentials", Boolean.toString(true));
        }
    }

    protected void setExposeHeaders(List<String> exposedHeaders, MutableHttpResponse<?> response) {
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", exposedHeaders);
            if (StringUtils.isNotEmpty(headerValue)) {
                response.header("Access-Control-Expose-Headers", headerValue);
            }
        } else {
            exposedHeaders.forEach(header -> response.header("Access-Control-Expose-Headers", (CharSequence)header));
        }
    }

    protected void setVary(MutableHttpResponse<?> response) {
        response.header("Vary", "Origin");
    }

    protected void setOrigin(@Nullable String origin, @NonNull MutableHttpResponse<?> response) {
        if (origin != null) {
            response.header("Access-Control-Allow-Origin", origin);
        }
    }

    protected void setAllowMethods(HttpMethod method, MutableHttpResponse<?> response) {
        response.header("Access-Control-Allow-Methods", method);
    }

    protected void setAllowHeaders(List<?> optionalAllowHeaders, MutableHttpResponse<?> response) {
        List allowHeaders = optionalAllowHeaders.stream().map(Object::toString).collect(Collectors.toList());
        if (this.corsConfiguration.isSingleHeader()) {
            String headerValue = String.join((CharSequence)",", allowHeaders);
            if (StringUtils.isNotEmpty(headerValue)) {
                response.header("Access-Control-Allow-Headers", headerValue);
            }
        } else {
            allowHeaders.stream().map(StringUtils::trimLeadingWhitespace).forEach(header -> response.header("Access-Control-Allow-Headers", (CharSequence)header));
        }
    }

    protected void setMaxAge(long maxAge, MutableHttpResponse<?> response) {
        if (maxAge > -1L) {
            response.header("Access-Control-Max-Age", Long.toString(maxAge));
        }
    }

    @NonNull
    private Optional<CorsOriginConfiguration> getConfiguration(@NonNull HttpRequest<?> request) {
        String requestOrigin = request.getOrigin().orElse(null);
        if (requestOrigin == null) {
            return Optional.empty();
        }
        Optional<CorsOriginConfiguration> originConfiguration = CrossOriginUtil.getCorsOriginConfigurationForRequest(request);
        if (originConfiguration.isPresent() && CorsFilter.matchesOrigin(originConfiguration.get(), requestOrigin)) {
            return originConfiguration;
        }
        if (!this.corsConfiguration.isEnabled()) {
            return Optional.empty();
        }
        return this.corsConfiguration.getConfigurations().values().stream().filter(config -> CorsFilter.matchesOrigin(config, requestOrigin)).findFirst();
    }

    private static boolean matchesOrigin(@NonNull CorsOriginConfiguration config, String requestOrigin) {
        if (config.getAllowedOriginsRegex().map(regex -> CorsFilter.matchesOrigin(regex, requestOrigin)).orElse(false).booleanValue()) {
            return true;
        }
        List<String> allowedOrigins = config.getAllowedOrigins();
        return !allowedOrigins.isEmpty() && (!config.getAllowedOriginsRegex().isPresent() && CorsFilter.isAny(allowedOrigins) || allowedOrigins.stream().anyMatch(origin -> origin.equals(requestOrigin)));
    }

    private static boolean matchesOrigin(@NonNull String originRegex, @NonNull String requestOrigin) {
        Pattern p = Pattern.compile(originRegex);
        Matcher m = p.matcher(requestOrigin);
        return m.matches();
    }

    private static boolean isAny(List<String> values) {
        return values == CorsOriginConfiguration.ANY;
    }

    private static boolean isAnyMethod(List<HttpMethod> allowedMethods) {
        return allowedMethods == CorsOriginConfiguration.ANY_METHOD;
    }

    private boolean methodAllowed(@NonNull CorsOriginConfiguration config, @NonNull HttpMethod methodToMatch) {
        List<HttpMethod> allowedMethods = config.getAllowedMethods();
        return CorsFilter.isAnyMethod(allowedMethods) || allowedMethods.stream().anyMatch(method -> method.equals(methodToMatch));
    }

    @NonNull
    private HttpMethod methodToMatch(@NonNull HttpRequest<?> request) {
        HttpMethod requestMethod = request.getMethod();
        return CorsUtil.isPreflightRequest(request) ? request.getHeaders().getFirst((CharSequence)"Access-Control-Request-Method", CONVERSION_CONTEXT_HTTP_METHOD).orElse(requestMethod) : requestMethod;
    }

    private boolean hasAllowedHeaders(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        Optional<List<String>> accessControlHeaders = request.getHeaders().get("Access-Control-Request-Headers", ConversionContext.LIST_OF_STRING);
        List<String> allowedHeaders = config.getAllowedHeaders();
        return CorsFilter.isAny(allowedHeaders) || accessControlHeaders.isPresent() && accessControlHeaders.get().stream().allMatch(header -> allowedHeaders.stream().anyMatch(allowedHeader -> allowedHeader.equalsIgnoreCase(header.trim())));
    }

    @NotNull
    private static MutableHttpResponse<Object> forbidden() {
        return HttpResponse.status(HttpStatus.FORBIDDEN);
    }

    @NonNull
    private void decorateResponseWithHeadersForPreflightRequest(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull CorsOriginConfiguration config) {
        HttpHeaders headers = request.getHeaders();
        headers.getFirst((CharSequence)"Access-Control-Request-Method", CONVERSION_CONTEXT_HTTP_METHOD).ifPresent(methods -> this.setAllowMethods((HttpMethod)methods, response));
        headers.get("Access-Control-Request-Headers", ConversionContext.LIST_OF_STRING).ifPresent(val -> this.setAllowHeaders((List<?>)val, response));
        this.setMaxAge(config.getMaxAge(), response);
    }

    @NonNull
    private void decorateResponseWithHeaders(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull CorsOriginConfiguration config) {
        this.setOrigin(request.getOrigin().orElse(null), response);
        this.setVary(response);
        this.setExposeHeaders(config.getExposedHeaders(), response);
        this.setAllowCredentials(config, response);
    }

    @NonNull
    private MutableHttpResponse<?> handlePreflightRequest(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration corsOriginConfiguration) {
        Optional<HttpStatus> statusOptional = this.validatePreflightRequest(request, corsOriginConfiguration);
        if (statusOptional.isPresent()) {
            HttpStatus status = statusOptional.get();
            if (status.getCode() >= 400) {
                return HttpResponse.status(status);
            }
            MutableHttpResponse resp = HttpResponse.status(status);
            this.decorateResponseWithHeadersForPreflightRequest(request, resp, corsOriginConfiguration);
            this.decorateResponseWithHeaders(request, resp, corsOriginConfiguration);
            return resp;
        }
        return null;
    }

    @NonNull
    private Optional<HttpStatus> validatePreflightRequest(@NonNull HttpRequest<?> request, @NonNull CorsOriginConfiguration config) {
        Optional<HttpMethod> methodToMatchOptional = this.validateMethodToMatch(request, config);
        if (!methodToMatchOptional.isPresent()) {
            return Optional.of(HttpStatus.FORBIDDEN);
        }
        HttpMethod methodToMatch = methodToMatchOptional.get();
        Optional<?> availableHttpMethods = request.getAttribute(HttpAttributes.AVAILABLE_HTTP_METHODS, new ArrayList().getClass());
        if (CorsUtil.isPreflightRequest(request) && availableHttpMethods.isPresent() && ((ArrayList)availableHttpMethods.get()).stream().anyMatch(method -> method.equals(methodToMatch))) {
            if (!this.hasAllowedHeaders(request, config)) {
                return Optional.of(HttpStatus.FORBIDDEN);
            }
            return Optional.of(HttpStatus.OK);
        }
        return Optional.empty();
    }
}

