/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.reference.PropertyReference;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import io.micronaut.serde.support.deserializers.SubtypedDeserBean;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

final class SpecificObjectDeserializer
implements Deserializer<Object>,
UpdatingDeserializer<Object> {
    private static final String PREFIX_UNABLE_TO_DESERIALIZE_TYPE = "Unable to deserialize type [";
    private final boolean ignoreUnknown;
    private final boolean strictNullable;
    private final DeserBean<? super Object> deserBean;
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;

    public SpecificObjectDeserializer(boolean ignoreUnknown, boolean strictNullable, DeserBean<? super Object> deserBean, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.ignoreUnknown = ignoreUnknown && deserBean.ignoreUnknown;
        this.strictNullable = strictNullable;
        this.deserBean = deserBean;
        this.preInstantiateCallback = preInstantiateCallback;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        Object obj;
        AnyValues<Object> anyValues;
        DeserBean<? super Object> db = this.deserBean;
        Class objectType = db.introspection.getBeanType();
        if (db.delegating) {
            if (db.creatorParams != null) {
                PropertiesBag.Consumer creatorParams = db.creatorParams.newConsumer();
                DeserBean.DerProperty<Object, Object> creator = creatorParams.getNotConsumed().iterator().next();
                Object val = this.deserializeValue(decoderContext, decoder, creator, creator.argument, null);
                Object[] args = new Object[]{val};
                if (this.preInstantiateCallback != null) {
                    this.preInstantiateCallback.preInstantiate(db.introspection, args);
                }
                return db.introspection.instantiate(this.strictNullable, args);
            }
            throw new IllegalStateException("At least one creator parameter expected");
        }
        PropertiesBag.Consumer readProperties = db.readProperties != null ? db.readProperties.newConsumer() : null;
        boolean hasProperties = readProperties != null;
        Decoder wrapperObjectOuterDecoder = null;
        Decoder objectDecoder = decoder.decodeObject(type);
        TokenBuffer tokenBuffer = null;
        AnyValues<Object> anyValues2 = anyValues = db.anySetter != null ? new AnyValues<Object>(db.anySetter) : null;
        if (db.isSubtyped() && db instanceof SubtypedDeserBean) {
            DeserBean<? super Object> deserBean;
            SubtypedDeserBean subtypedDeserBean = (SubtypedDeserBean)db;
            String defaultImpl = subtypedDeserBean.defaultImpl;
            String discriminatorName = subtypedDeserBean.discriminatorName;
            Map subtypes = subtypedDeserBean.subtypes;
            SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = subtypedDeserBean.discriminatorType;
            if (discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY) {
                String string;
                while ((string = objectDecoder.decodeKey()) != null) {
                    if (string.equals(discriminatorName)) {
                        String subtypeName;
                        DeserBean<? super Object> subtypeDeser;
                        if (objectDecoder.decodeNull() || (subtypeDeser = subtypes.get(subtypeName = objectDecoder.decodeString())) == null) break;
                        db = subtypeDeser;
                        objectType = subtypeDeser.introspection.getBeanType();
                        readProperties = db.readProperties != null ? db.readProperties.newConsumer() : null;
                        hasProperties = readProperties != null;
                        anyValues = db.anySetter != null ? new AnyValues<Object>(db.anySetter) : null;
                        break;
                    }
                    tokenBuffer = this.initTokenBuffer(tokenBuffer, objectDecoder, string);
                }
            } else {
                String string;
                while ((string = objectDecoder.decodeKey()) != null) {
                    DeserBean<? super Object> subtypeBean = subtypes.get(string);
                    if (subtypeBean != null) {
                        if (objectDecoder.decodeNull()) break;
                        wrapperObjectOuterDecoder = objectDecoder;
                        objectDecoder = objectDecoder.decodeObject(type);
                        db = subtypeBean;
                        objectType = subtypeBean.introspection.getBeanType();
                        readProperties = db.readProperties != null ? db.readProperties.newConsumer() : null;
                        hasProperties = readProperties != null;
                        break;
                    }
                    if (anyValues != null) {
                        tokenBuffer = this.initTokenBuffer(tokenBuffer, objectDecoder, string);
                        continue;
                    }
                    objectDecoder.skipValue();
                }
            }
            if (defaultImpl != null && subtypedDeserBean == db && (deserBean = subtypes.get(defaultImpl)) != null) {
                db = deserBean;
                objectType = deserBean.introspection.getBeanType();
                readProperties = db.readProperties != null ? db.readProperties.newConsumer() : null;
                boolean bl = hasProperties = readProperties != null;
            }
        }
        if (db.creatorParams != null) {
            Iterator prop;
            PropertiesBag.Consumer creatorParameters = db.creatorParams.newConsumer();
            int creatorSize = db.creatorSize;
            Object[] params = new Object[creatorSize];
            PropertyBuffer buffer = this.initFromTokenBuffer(tokenBuffer, creatorParameters, readProperties, anyValues, decoderContext);
            while ((prop = objectDecoder.decodeKey()) != null) {
                DeserBean.DerProperty<Object, Object> rp;
                DeserBean.DerProperty<Object, Object> derProperty = creatorParameters.consume((String)((Object)prop));
                boolean consumed = false;
                if (derProperty != null) {
                    if (derProperty.views != null && !decoderContext.hasView(derProperty.views)) {
                        objectDecoder.skipValue();
                        continue;
                    }
                    Object val = this.deserializeValue(decoderContext, objectDecoder, derProperty, derProperty.argument, null);
                    if (val == null) {
                        derProperty.setDefaultConstructorValue(decoderContext, params);
                        continue;
                    }
                    if (derProperty.instrospection.getBeanType() == objectType) {
                        params[derProperty.index] = val;
                        if (hasProperties && readProperties.isNotConsumed((String)((Object)prop))) {
                            buffer = this.initBuffer(buffer, (DeserBean.DerProperty<? super Object, ?>)derProperty, (String)((Object)prop), val);
                        }
                    } else {
                        buffer = this.initBuffer(buffer, (DeserBean.DerProperty<? super Object, ?>)derProperty, (String)((Object)prop), val);
                    }
                    if (creatorParameters.isAllConsumed()) break;
                    consumed = true;
                } else if (hasProperties && (rp = readProperties.findNotConsumed((String)((Object)prop))) != null) {
                    if (rp.managedRef != null) {
                        tokenBuffer = this.initTokenBuffer(tokenBuffer, objectDecoder, (String)((Object)prop));
                    } else {
                        Object val = this.deserializeValue(decoderContext, objectDecoder, rp, rp.argument, null);
                        buffer = this.initBuffer(buffer, (DeserBean.DerProperty<? super Object, ?>)rp, (String)((Object)prop), val);
                    }
                    consumed = true;
                }
                if (consumed) continue;
                this.skipOrSetAny(decoderContext, objectDecoder, (String)((Object)prop), anyValues, this.ignoreUnknown, type);
            }
            if (buffer != null && !creatorParameters.isAllConsumed()) {
                for (PropertyBuffer propertyBuffer : buffer) {
                    DeserBean.DerProperty derProperty = creatorParameters.consume(propertyBuffer.name);
                    if (derProperty == null) continue;
                    propertyBuffer.set(params, decoderContext);
                }
            }
            if (!creatorParameters.isAllConsumed()) {
                for (DeserBean.DerProperty<Object, Object> derProperty : creatorParameters.getNotConsumed()) {
                    PropertyReference ref;
                    if (derProperty.backRef != null && (ref = decoderContext.resolveReference(new PropertyReference(derProperty.backRef, derProperty.instrospection, derProperty.argument, null))) != null) {
                        Object o = ref.getReference();
                        if (o == null) {
                            derProperty.setDefaultConstructorValue(decoderContext, params);
                            continue;
                        }
                        params[derProperty.index] = o;
                        continue;
                    }
                    if (derProperty.unwrapped != null && buffer != null) {
                        Object o = this.materializeFromBuffer(derProperty, buffer, decoderContext);
                        if (o == null) {
                            derProperty.setDefaultConstructorValue(decoderContext, params);
                            continue;
                        }
                        params[derProperty.index] = o;
                        continue;
                    }
                    if (derProperty.isAnySetter && anyValues != null) {
                        anyValues.bind(params);
                        anyValues = null;
                        continue;
                    }
                    derProperty.setDefaultConstructorValue(decoderContext, params);
                }
            }
            try {
                if (this.preInstantiateCallback != null) {
                    this.preInstantiateCallback.preInstantiate(db.introspection, params);
                }
                obj = db.introspection.instantiate(this.strictNullable, params);
            }
            catch (InstantiationException e) {
                throw new SerdeException(PREFIX_UNABLE_TO_DESERIALIZE_TYPE + type + "]: " + e.getMessage(), e);
            }
            if (hasProperties) {
                if (buffer != null) {
                    this.processPropertyBuffer(decoderContext, objectType, readProperties, obj, buffer);
                }
                if (tokenBuffer != null && (buffer = this.initFromTokenBuffer(tokenBuffer, creatorParameters, readProperties, anyValues, decoderContext)) != null) {
                    this.processPropertyBuffer(decoderContext, objectType, readProperties, obj, buffer);
                }
                if (!readProperties.isAllConsumed()) {
                    buffer = this.decodeProperties(db, decoderContext, obj, objectDecoder, readProperties, db.unwrappedProperties == null, buffer, anyValues, this.ignoreUnknown, type);
                }
                this.applyDefaultValuesOrFail(obj, readProperties, db.unwrappedProperties, buffer, decoderContext);
            }
        } else {
            if (db.hasBuilder) {
                BeanIntrospection.Builder builder;
                try {
                    if (this.preInstantiateCallback != null) {
                        this.preInstantiateCallback.preInstantiate(db.introspection, new Object[0]);
                    }
                    builder = db.introspection.builder();
                }
                catch (InstantiationException e) {
                    throw new SerdeException(PREFIX_UNABLE_TO_DESERIALIZE_TYPE + type + "]: " + e.getMessage(), e);
                }
                if (hasProperties) {
                    String prop;
                    if (tokenBuffer != null) {
                        for (TokenBuffer buffer : tokenBuffer) {
                            DeserBean.DerProperty property = readProperties.consume(buffer.name);
                            if (property != null) {
                                property.deserializeAndCallBuilder(buffer.decoder, decoderContext, builder);
                                continue;
                            }
                            this.skipOrSetAny(decoderContext, buffer.decoder, buffer.name, anyValues, this.ignoreUnknown, type);
                        }
                    }
                    while ((prop = objectDecoder.decodeKey()) != null) {
                        DeserBean.DerProperty property = readProperties.consume(prop);
                        if (property != null) {
                            property.deserializeAndCallBuilder(objectDecoder, decoderContext, builder);
                            continue;
                        }
                        this.skipOrSetAny(decoderContext, objectDecoder, prop, anyValues, this.ignoreUnknown, type);
                    }
                }
                try {
                    obj = builder.build();
                }
                catch (InstantiationException e) {
                    throw new SerdeException(PREFIX_UNABLE_TO_DESERIALIZE_TYPE + type + "]: " + e.getMessage(), e);
                }
            }
            try {
                if (this.preInstantiateCallback != null) {
                    this.preInstantiateCallback.preInstantiate(db.introspection, new Object[0]);
                }
                obj = db.introspection.instantiate(this.strictNullable, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
            catch (InstantiationException e) {
                throw new SerdeException(PREFIX_UNABLE_TO_DESERIALIZE_TYPE + type + "]: " + e.getMessage(), e);
            }
            if (hasProperties) {
                PropertyBuffer existingBuffer = this.initFromTokenBuffer(tokenBuffer, null, readProperties, anyValues, decoderContext);
                PropertyBuffer propertyBuffer = this.decodeProperties(db, decoderContext, obj, objectDecoder, readProperties, db.unwrappedProperties == null, existingBuffer, anyValues, this.ignoreUnknown, type);
                this.applyDefaultValuesOrFail(obj, readProperties, db.unwrappedProperties, propertyBuffer, decoderContext);
            } else if (anyValues != null && tokenBuffer != null) {
                for (TokenBuffer buffer : tokenBuffer) {
                    anyValues.handle(buffer.name, buffer.decoder, decoderContext);
                }
            }
        }
        this.finalizeObjectDecoder(decoderContext, type, this.ignoreUnknown, objectDecoder, anyValues, obj);
        if (wrapperObjectOuterDecoder != null) {
            wrapperObjectOuterDecoder.finishStructure(true);
        }
        return obj;
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    private void processPropertyBuffer(Deserializer.DecoderContext decoderContext, Class<? super Object> objectType, PropertiesBag.Consumer readProperties, Object obj, PropertyBuffer buffer) throws IOException {
        for (PropertyBuffer propertyBuffer : buffer) {
            DeserBean.DerProperty derProperty = readProperties.consume(propertyBuffer.name);
            if (derProperty == null || derProperty.instrospection.getBeanType() != objectType) continue;
            propertyBuffer.set(obj, decoderContext);
        }
    }

    private Object deserializeValue(Deserializer.DecoderContext decoderContext, Decoder objectDecoder, DeserBean.DerProperty<Object, Object> derProperty, Argument<Object> propertyType, Object constructedBean) throws IOException {
        boolean hasRef = constructedBean != null && derProperty.managedRef != null;
        try {
            if (hasRef) {
                decoderContext.pushManagedRef(new PropertyReference(derProperty.managedRef, derProperty.instrospection, derProperty.argument, constructedBean));
            }
            Deserializer deserializer = derProperty.deserializer;
            Object object = deserializer.deserializeNullable(objectDecoder, decoderContext, propertyType);
            return object;
        }
        catch (InvalidFormatException e) {
            throw new InvalidPropertyFormatException(e, propertyType);
        }
        finally {
            if (hasRef) {
                decoderContext.popManagedRef();
            }
        }
    }

    private void finalizeObjectDecoder(Deserializer.DecoderContext decoderContext, Argument<? super Object> type, boolean ignoreUnknown, Decoder objectDecoder, AnyValues<Object> anyValues, Object obj) throws IOException {
        if (anyValues == null && ignoreUnknown) {
            objectDecoder.finishStructure(true);
        } else {
            String key;
            while ((key = objectDecoder.decodeKey()) != null) {
                this.skipOrSetAny(decoderContext, objectDecoder, key, anyValues, ignoreUnknown, type);
            }
            if (anyValues != null) {
                anyValues.bind(obj);
            }
            objectDecoder.finishStructure();
        }
    }

    private TokenBuffer initTokenBuffer(TokenBuffer tokenBuffer, Decoder objectDecoder, String key) throws IOException {
        return tokenBuffer == null ? new TokenBuffer(key, objectDecoder.decodeBuffer(), null) : tokenBuffer.next(key, objectDecoder.decodeBuffer());
    }

    @Nullable
    private PropertyBuffer initFromTokenBuffer(@Nullable TokenBuffer tokenBuffer, @Nullable PropertiesBag.Consumer creatorParameters, @Nullable PropertiesBag.Consumer readProperties, @Nullable AnyValues<?> anyValues, Deserializer.DecoderContext decoderContext) throws IOException {
        if (tokenBuffer != null) {
            PropertyBuffer propertyBuffer = null;
            for (TokenBuffer buffer : tokenBuffer) {
                DeserBean.DerProperty derProperty;
                String n = buffer.name;
                if (creatorParameters != null && (derProperty = creatorParameters.findNotConsumed(n)) != null) {
                    propertyBuffer = this.initBuffer(propertyBuffer, derProperty, n, buffer.decoder);
                    continue;
                }
                if (readProperties != null && (derProperty = readProperties.findNotConsumed(n)) != null) {
                    propertyBuffer = this.initBuffer(propertyBuffer, derProperty, n, buffer.decoder);
                    continue;
                }
                if (anyValues == null) continue;
                anyValues.handle(buffer.name, buffer.decoder, decoderContext);
            }
            return propertyBuffer;
        }
        return null;
    }

    private PropertyBuffer initBuffer(PropertyBuffer buffer, DeserBean.DerProperty<? super Object, ?> rp, String prop, Object val) {
        buffer = buffer == null ? new PropertyBuffer(rp, prop, val, null) : buffer.next(rp, prop, val);
        return buffer;
    }

    private PropertyBuffer decodeProperties(DeserBean<? super Object> introspection, Deserializer.DecoderContext decoderContext, Object obj, Decoder objectDecoder, PropertiesBag.Consumer readProperties, boolean hasNoUnwrapped, PropertyBuffer propertyBuffer, @Nullable AnyValues<?> anyValues, boolean ignoreUnknown, Argument<?> beanType) throws IOException {
        String prop;
        while ((prop = objectDecoder.decodeKey()) != null) {
            DeserBean.DerProperty<Object, Object> property = readProperties.consume(prop);
            if (property != null && property.beanProperty != null) {
                if (property.views != null && !decoderContext.hasView(property.views)) {
                    objectDecoder.skipValue();
                    continue;
                }
                boolean isNull = objectDecoder.decodeNull();
                if (isNull) {
                    if (property.argument.isNullable()) {
                        property.set(obj, null);
                        continue;
                    }
                    property.setDefaultPropertyValue(decoderContext, obj);
                    continue;
                }
                Object val = this.deserializeValue(decoderContext, objectDecoder, property, property.argument, obj);
                if (introspection.introspection == property.instrospection) {
                    property.set(obj, val);
                } else {
                    propertyBuffer = this.initBuffer(propertyBuffer, property, prop, val);
                }
                if (!readProperties.isAllConsumed() || !hasNoUnwrapped || introspection.anySetter != null) continue;
                break;
            }
            this.skipOrSetAny(decoderContext, objectDecoder, prop, anyValues, ignoreUnknown, beanType);
        }
        return propertyBuffer;
    }

    private void skipOrSetAny(Deserializer.DecoderContext decoderContext, Decoder objectDecoder, String property, @Nullable AnyValues<?> anyValues, boolean ignoreUnknown, Argument<?> type) throws IOException {
        if (anyValues != null) {
            anyValues.handle(property, objectDecoder, decoderContext);
        } else if (ignoreUnknown) {
            objectDecoder.skipValue();
        } else {
            throw new SerdeException("Unknown property [" + property + "] encountered during deserialization of type: " + type);
        }
    }

    private void applyDefaultValuesOrFail(Object obj, PropertiesBag.Consumer readProperties, @Nullable DeserBean.DerProperty<? super Object, Object>[] unwrappedProperties, @Nullable PropertyBuffer buffer, Deserializer.DecoderContext decoderContext) throws IOException {
        if (ArrayUtils.isNotEmpty(unwrappedProperties)) {
            for (DeserBean.DerProperty<? super Object, Object> dp : unwrappedProperties) {
                if (dp.views != null && !decoderContext.hasView(dp.views)) continue;
                if (buffer == null) {
                    dp.set(obj, null);
                    continue;
                }
                Object v = this.materializeFromBuffer((DeserBean.DerProperty<Object, Object>)dp, buffer, decoderContext);
                dp.set(obj, v);
            }
        }
        if (buffer != null && !readProperties.isAllConsumed()) {
            for (PropertyBuffer propertyBuffer : buffer) {
                DeserBean.DerProperty derProperty = readProperties.consume(propertyBuffer.name);
                if (derProperty == null) continue;
                propertyBuffer.set(obj, decoderContext);
            }
        }
        if (!readProperties.isAllConsumed()) {
            for (DeserBean.DerProperty derProperty : readProperties.getNotConsumed()) {
                if (derProperty.backRef != null) {
                    PropertyReference ref = decoderContext.resolveReference(new PropertyReference(derProperty.backRef, derProperty.instrospection, derProperty.argument, null));
                    if (ref == null) continue;
                    Object o = ref.getReference();
                    if (o == null) {
                        derProperty.setDefaultPropertyValue(decoderContext, obj);
                        continue;
                    }
                    derProperty.set(obj, o);
                    continue;
                }
                derProperty.setDefaultPropertyValue(decoderContext, obj);
            }
        }
    }

    @Nullable
    private Object materializeFromBuffer(DeserBean.DerProperty<Object, Object> property, PropertyBuffer buffer, Deserializer.DecoderContext decoderContext) throws IOException {
        DeserBean<Object> unwrapped = property.unwrapped;
        if (unwrapped != null) {
            return this.materializeUnwrapped(buffer, decoderContext, unwrapped);
        }
        return null;
    }

    private Object materializeUnwrapped(PropertyBuffer buffer, Deserializer.DecoderContext decoderContext, DeserBean<Object> unwrapped) throws IOException {
        Object object;
        int satisfied;
        if (unwrapped.creatorParams != null) {
            Object[] params = new Object[unwrapped.creatorSize];
            for (DeserBean.DerProperty derProperty : unwrapped.creatorParams.getDerProperties()) {
                satisfied = 0;
                for (PropertyBuffer pb : buffer) {
                    if (pb.property != derProperty) continue;
                    pb.set(params, decoderContext);
                    satisfied = 1;
                    break;
                }
                if (satisfied != 0) continue;
                if (derProperty.defaultValue != null) {
                    params[derProperty.index] = derProperty.defaultValue;
                    continue;
                }
                if (!derProperty.mustSetField) continue;
                throw new SerdeException(PREFIX_UNABLE_TO_DESERIALIZE_TYPE + unwrapped.introspection.getBeanType() + "]. Required constructor parameter [" + derProperty.argument + "] at index [" + derProperty.index + "] is not present in supplied data");
            }
            if (this.preInstantiateCallback != null) {
                this.preInstantiateCallback.preInstantiate(unwrapped.introspection, params);
            }
            object = unwrapped.introspection.instantiate(this.strictNullable, params);
        } else {
            if (this.preInstantiateCallback != null) {
                this.preInstantiateCallback.preInstantiate(unwrapped.introspection, new Object[0]);
            }
            object = unwrapped.introspection.instantiate(this.strictNullable, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }
        if (unwrapped.readProperties != null) {
            @Nullable DeserBean.DerProperty<T, Object>[] nestedUnwrappedProperties = unwrapped.unwrappedProperties;
            if (nestedUnwrappedProperties != null) {
                for (DeserBean.DerProperty nestedUnwrappedProperty : nestedUnwrappedProperties) {
                    DeserBean<Object> nested = nestedUnwrappedProperty.unwrapped;
                    Object o = this.materializeUnwrapped(buffer, decoderContext, nested);
                    nestedUnwrappedProperty.set(object, o);
                }
            }
            for (DeserBean.DerProperty derProperty : unwrapped.readProperties.getDerProperties()) {
                satisfied = 0;
                for (PropertyBuffer pb : buffer) {
                    DeserBean.DerProperty<Object, Object> property = pb.property;
                    if (property != derProperty) continue;
                    if (property.instrospection == unwrapped.introspection) {
                        pb.set(object, decoderContext);
                        derProperty.set(object, pb.value);
                    }
                    satisfied = 1;
                    break;
                }
                if (satisfied != 0) continue;
                derProperty.setDefaultPropertyValue(decoderContext, object);
            }
        }
        return object;
    }

    @Override
    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type, Object value) throws IOException {
        PropertiesBag.Consumer readProperties = this.deserBean.readProperties != null ? this.deserBean.readProperties.newConsumer() : null;
        boolean hasProperties = readProperties != null;
        boolean ignoreUnknown = this.ignoreUnknown && this.deserBean.ignoreUnknown;
        AnyValues<Object> anyValues = this.deserBean.anySetter != null ? new AnyValues<Object>(this.deserBean.anySetter) : null;
        Decoder objectDecoder = decoder.decodeObject(type);
        if (hasProperties) {
            PropertyBuffer propertyBuffer = this.decodeProperties(this.deserBean, decoderContext, value, objectDecoder, readProperties, this.deserBean.unwrappedProperties == null, null, anyValues, ignoreUnknown, type);
            this.applyDefaultValuesOrFail(value, readProperties, this.deserBean.unwrappedProperties, propertyBuffer, decoderContext);
        }
        this.finalizeObjectDecoder(decoderContext, type, ignoreUnknown, objectDecoder, anyValues, value);
    }

    private static final class AnyValues<T> {
        Map<String, T> values;
        final DeserBean.AnySetter<T> anySetter;

        private AnyValues(DeserBean.AnySetter<T> anySetter) {
            this.anySetter = anySetter;
        }

        void handle(String property, Decoder objectDecoder, Deserializer.DecoderContext decoderContext) throws IOException {
            if (this.values == null) {
                this.values = new LinkedHashMap<String, T>();
            }
            if (objectDecoder.decodeNull()) {
                this.values.put(property, null);
            } else if (this.anySetter.deserializer != null) {
                Object deserializedValue = this.anySetter.deserializer.deserializeNullable(objectDecoder, decoderContext, this.anySetter.valueType);
                this.values.put(property, deserializedValue);
            } else {
                this.values.put(property, objectDecoder.decodeArbitrary());
            }
        }

        void bind(Object obj) {
            if (this.values != null) {
                this.anySetter.bind(this.values, obj);
            }
        }
    }

    private static final class TokenBuffer
    implements Iterable<TokenBuffer> {
        final String name;
        final Decoder decoder;
        private final TokenBuffer next;

        private TokenBuffer(@NonNull String name, @NonNull Decoder decoder, @Nullable TokenBuffer next) {
            this.name = name;
            this.decoder = decoder;
            this.next = next;
        }

        TokenBuffer next(@NonNull String name, @NonNull Decoder decoder) {
            return new TokenBuffer(name, decoder, this);
        }

        @Override
        public Iterator<TokenBuffer> iterator() {
            return new Iterator<TokenBuffer>(){
                TokenBuffer thisBuffer = null;

                @Override
                public boolean hasNext() {
                    return this.thisBuffer == null || this.thisBuffer.next != null;
                }

                @Override
                public TokenBuffer next() throws NoSuchElementException {
                    this.thisBuffer = this.thisBuffer == null ? this : this.thisBuffer.next;
                    if (this.thisBuffer == null) {
                        throw new NoSuchElementException();
                    }
                    return this.thisBuffer;
                }
            };
        }
    }

    private static final class PropertyBuffer
    implements Iterable<PropertyBuffer> {
        final DeserBean.DerProperty<Object, Object> property;
        final String name;
        private Object value;
        private final PropertyBuffer next;

        public PropertyBuffer(DeserBean.DerProperty<? super Object, ?> derProperty, String name, Object val, @Nullable PropertyBuffer next) {
            this.property = derProperty;
            this.name = name;
            this.value = val;
            this.next = next;
        }

        PropertyBuffer next(DeserBean.DerProperty<? super Object, ?> rp, String property, Object val) {
            return new PropertyBuffer(rp, property, val, this);
        }

        @Override
        public Iterator<PropertyBuffer> iterator() {
            return new Iterator<PropertyBuffer>(){
                PropertyBuffer thisBuffer = null;

                @Override
                public boolean hasNext() {
                    return this.thisBuffer == null || this.thisBuffer.next != null;
                }

                @Override
                public PropertyBuffer next() throws NoSuchElementException {
                    this.thisBuffer = this.thisBuffer == null ? this : this.thisBuffer.next;
                    if (this.thisBuffer == null) {
                        throw new NoSuchElementException();
                    }
                    return this.thisBuffer;
                }
            };
        }

        public void set(Object obj, Deserializer.DecoderContext decoderContext) throws IOException {
            Object object = this.value;
            if (object instanceof Decoder) {
                Decoder decoder = (Decoder)object;
                if (this.property.managedRef != null) {
                    decoderContext.pushManagedRef(new PropertyReference(this.property.managedRef, this.property.instrospection, this.property.argument, obj));
                }
                try {
                    this.value = this.property.deserializer.deserializeNullable(decoder, decoderContext, this.property.argument);
                }
                catch (InvalidFormatException e) {
                    throw new InvalidPropertyFormatException(e, this.property.argument);
                }
                finally {
                    decoderContext.popManagedRef();
                }
            }
            this.property.set(obj, this.value);
        }

        public void set(Object[] params, Deserializer.DecoderContext decoderContext) throws IOException {
            Object object = this.value;
            if (object instanceof Decoder) {
                Decoder decoder = (Decoder)object;
                try {
                    this.value = this.property.deserializer.deserializeNullable(decoder, decoderContext, this.property.argument);
                }
                catch (InvalidFormatException e) {
                    throw new InvalidPropertyFormatException(e, this.property.argument);
                }
            }
            params[this.property.index] = this.value;
        }
    }
}

