/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.deserializers.collect.CollectionDeserializer;
import java.io.IOException;
import java.util.HashSet;

final class HashSetDeserializer<E>
extends CollectionDeserializer<E, HashSet<E>> {
    HashSetDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        super(valueDeser, collectionItemArgument);
    }

    @Override
    public HashSet<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super HashSet<E>> type) throws IOException {
        HashSet collection = new HashSet();
        this.doDeserialize(decoder, context, collection);
        return collection;
    }

    @Override
    public HashSet<E> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super HashSet<E>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public HashSet<E> getDefaultValue(Deserializer.DecoderContext context, Argument<? super HashSet<E>> type) {
        return new HashSet();
    }
}

