/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.Around;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.Introduction;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.internal.intercepted.CompletionStageInterceptedMethod;
import io.micronaut.aop.internal.intercepted.KotlinInterceptedMethodImpl;
import io.micronaut.aop.internal.intercepted.PublisherInterceptedMethod;
import io.micronaut.aop.internal.intercepted.ReactorInterceptedMethod;
import io.micronaut.aop.internal.intercepted.SynchronousInterceptedMethod;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.ReturnType;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

@Internal
public final class InterceptedMethodUtil {
    private InterceptedMethodUtil() {
    }

    @NonNull
    public static InterceptedMethod of(@NonNull MethodInvocationContext<?, ?> context, @NonNull ConversionService conversionService) {
        if (context.isSuspend()) {
            KotlinInterceptedMethodImpl kotlinInterceptedMethod = KotlinInterceptedMethodImpl.of(context);
            if (kotlinInterceptedMethod != null) {
                return kotlinInterceptedMethod;
            }
            return new SynchronousInterceptedMethod(context);
        }
        ReturnType returnType = context.getReturnType();
        Class returnTypeClass = returnType.getType();
        if (returnTypeClass == Void.TYPE || returnTypeClass == String.class) {
            return new SynchronousInterceptedMethod(context);
        }
        if (CompletionStage.class.isAssignableFrom(returnTypeClass) || Future.class.isAssignableFrom(returnTypeClass)) {
            return new CompletionStageInterceptedMethod(context, conversionService);
        }
        if (PublisherInterceptedMethod.isConvertibleToPublisher(returnTypeClass)) {
            if (ReactorInterceptedMethod.REACTOR_AVAILABLE) {
                return new ReactorInterceptedMethod(context, conversionService);
            }
            return new PublisherInterceptedMethod(context, conversionService);
        }
        return new SynchronousInterceptedMethod(context);
    }

    public static AnnotationValue<?>[] resolveInterceptorBinding(AnnotationMetadata annotationMetadata, InterceptorKind interceptorKind) {
        List<AnnotationValue<InterceptorBinding>> interceptorBindings = annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class);
        if (!interceptorBindings.isEmpty()) {
            return (AnnotationValue[])interceptorBindings.stream().filter(av -> {
                InterceptorKind kind = av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND);
                return kind == interceptorKind;
            }).toArray(AnnotationValue[]::new);
        }
        return AnnotationUtil.ZERO_ANNOTATION_VALUES;
    }

    public static boolean hasAroundStereotype(@Nullable AnnotationMetadata annotationMetadata) {
        return InterceptedMethodUtil.hasInterceptorBinding(annotationMetadata, false, Around.class, InterceptorKind.AROUND);
    }

    public static boolean hasIntroductionStereotype(@Nullable AnnotationMetadata annotationMetadata) {
        return InterceptedMethodUtil.hasInterceptorBinding(annotationMetadata, false, Introduction.class, InterceptorKind.INTRODUCTION);
    }

    public static boolean hasDeclaredAroundAdvice(@Nullable AnnotationMetadata annotationMetadata) {
        return InterceptedMethodUtil.hasInterceptorBinding(annotationMetadata, true, Around.class, InterceptorKind.AROUND);
    }

    private static boolean hasInterceptorBinding(AnnotationMetadata annotationMetadata, boolean declared, Class<? extends Annotation> interceptorAnnotation, InterceptorKind kind) {
        List<AnnotationValue<InterceptorBinding>> annotationsValues;
        if (declared) {
            if (annotationMetadata.hasDeclaredStereotype(interceptorAnnotation)) {
                return true;
            }
            annotationsValues = annotationMetadata.getDeclaredAnnotationValuesByType(InterceptorBinding.class);
        } else {
            if (annotationMetadata.hasStereotype(interceptorAnnotation)) {
                return true;
            }
            annotationsValues = annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class);
        }
        return annotationsValues.stream().anyMatch(av -> av.enumValue("kind", InterceptorKind.class).orElse(InterceptorKind.AROUND) == kind);
    }
}

