/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.internal.intercepted.PublisherInterceptedMethod;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.ReturnType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
final class ReactorInterceptedMethod
extends PublisherInterceptedMethod {
    public static final boolean REACTOR_AVAILABLE = ClassUtils.isPresent("reactor.core.publisher.Mono", ReactorInterceptedMethod.class.getClassLoader());

    ReactorInterceptedMethod(MethodInvocationContext<?, ?> context, ConversionService conversionService) {
        super(context, conversionService);
    }

    @Override
    protected Object convertPublisherResult(ReturnType<?> returnType, Object result) {
        return this.captureContext(super.convertPublisherResult(returnType, result));
    }

    @Override
    protected Publisher<?> convertToPublisher(Object result) {
        return this.captureContext(super.convertToPublisher(result));
    }

    private <T> T captureContext(T result) {
        if (!PropagatedContext.exists()) {
            return result;
        }
        if (result instanceof Mono) {
            Mono mono = (Mono)result;
            PropagatedContext propagatedContext = PropagatedContext.get();
            return (T)mono.contextWrite(ctx -> ReactorPropagation.addPropagatedContext(ctx, propagatedContext));
        }
        if (result instanceof Flux) {
            Flux flux = (Flux)result;
            PropagatedContext propagatedContext = PropagatedContext.get();
            return (T)flux.contextWrite(ctx -> ReactorPropagation.addPropagatedContext(ctx, propagatedContext));
        }
        return result;
    }
}

