/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.AroundLegacyFilter;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.TerminalFilter;
import io.micronaut.http.filter.TerminalReactiveFilter;
import java.util.function.Function;
import org.reactivestreams.Publisher;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GenericHttpFilter {
    @Deprecated(forRemoval=true)
    default public boolean isSuspended() {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean isFiltersException() {
        return false;
    }

    @Internal
    public static GenericHttpFilter createLegacyFilter(HttpFilter bean, FilterOrder order) {
        return new AroundLegacyFilter(bean, order);
    }

    @Internal
    public static GenericHttpFilter terminalFilter(Function<HttpRequest<?>, ExecutionFlow<MutableHttpResponse<?>>> fn) {
        return new TerminalFilter(fn);
    }

    @Internal
    public static GenericHttpFilter terminalReactiveFilter(Publisher<? extends HttpResponse<?>> responsePublisher) {
        return new TerminalReactiveFilter(responsePublisher);
    }

    @Internal
    public static boolean isEnabled(GenericHttpFilter filter) {
        AroundLegacyFilter aroundLegacyFilter;
        return !(filter instanceof AroundLegacyFilter) || (aroundLegacyFilter = (AroundLegacyFilter)filter).isEnabled();
    }
}

