/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.body.HttpBody;
import io.micronaut.http.server.netty.body.ImmediateMultiObjectBody;
import io.micronaut.http.server.netty.body.ManagedBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.micronaut.json.convert.LazyJsonNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.ReferenceCounted;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public final class ImmediateSingleObjectBody
extends ManagedBody<Object>
implements HttpBody,
MultiObjectBody {
    ImmediateSingleObjectBody(Object value) {
        super(value);
    }

    @Override
    void release(Object value) {
        ImmediateSingleObjectBody.release0(value);
    }

    static void release0(Object value) {
        if (value instanceof LazyJsonNode) {
            LazyJsonNode rc = (LazyJsonNode)value;
            rc.tryRelease();
        } else if (value instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)value;
            rc.release();
        }
    }

    public Object claimForExternal() {
        return this.claim();
    }

    public Object valueUnclaimed() {
        return this.value();
    }

    public Optional<ImmediateSingleObjectBody> convert(ConversionService conversionService, ArgumentConversionContext<?> context) {
        Optional<Object> converted;
        Object o = this.prepareClaim();
        if (o instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)o;
            if (rc instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)rc;
                converted = conversionService.convert(byteBuf, ByteBuf.class, context.getArgument().getType(), context);
            } else {
                converted = conversionService.convert((Object)rc, context);
            }
            if (converted.isPresent()) {
                boolean targetRefCounted;
                rc.touch();
                Object item = converted.get();
                boolean bl = targetRefCounted = item instanceof ReferenceCounted || item instanceof io.micronaut.core.io.buffer.ReferenceCounted;
                if (!targetRefCounted) {
                    rc.release();
                }
            }
        } else {
            converted = conversionService.convert(o, context);
        }
        return converted.map(p -> this.next(new ImmediateSingleObjectBody(p)));
    }

    @Override
    public InputStream coerceToInputStream(ByteBufAllocator alloc) {
        return new ByteBufInputStream((ByteBuf)this.claim(), true);
    }

    @Override
    public Publisher<?> asPublisher() {
        return Flux.just(this.claim()).doOnDiscard(ReferenceCounted.class, ReferenceCounted::release);
    }

    @Override
    public MultiObjectBody mapNotNull(Function<Object, Object> transform) {
        Object result = transform.apply(this.prepareClaim());
        return this.next(result == null ? new ImmediateMultiObjectBody(List.of()) : new ImmediateSingleObjectBody(result));
    }

    @Override
    public void handleForm(FormRouteCompleter formRouteCompleter) {
        Flux.just(this.prepareClaim()).subscribe(formRouteCompleter);
        this.next(formRouteCompleter);
    }
}

