/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.exceptions.MessageBodyException;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.http.server.netty.body.AbstractFileBodyWriter;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.types.files.SystemFile;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

@Singleton
@Internal
public final class SystemFileBodyWriter
extends AbstractFileBodyWriter
implements NettyBodyWriter<SystemFile> {
    private static final String UNIT_BYTES = "bytes";

    public SystemFileBodyWriter(NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void writeTo(HttpRequest<?> request, MutableHttpResponse<SystemFile> outgoingResponse, Argument<SystemFile> type, MediaType mediaType, SystemFile object, NettyWriteContext nettyContext) throws CodecException {
        this.writeTo(request, outgoingResponse, object, nettyContext);
    }

    @Override
    public void writeTo(Argument<SystemFile> type, MediaType mediaType, SystemFile file, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException("Can only be used in a Netty context");
    }

    public void writeTo(HttpRequest<?> request, MutableHttpResponse<SystemFile> response, SystemFile systemFile, NettyWriteContext nettyContext) throws CodecException {
        if (response instanceof NettyMutableHttpResponse) {
            NettyMutableHttpResponse nettyResponse = (NettyMutableHttpResponse)response;
            if (!systemFile.getFile().canRead()) {
                throw new MessageBodyException("Could not find file");
            }
            if (this.handleIfModifiedAndHeaders(request, response, systemFile, nettyResponse)) {
                nettyContext.writeFull(this.notModified(response));
            } else {
                long fileLength = systemFile.getLength();
                long position = 0L;
                long contentLength = fileLength;
                if (fileLength > -1L) {
                    IntRange range;
                    String rangeHeader = (String)request.getHeaders().get("Range");
                    if (rangeHeader != null && request.getMethod() == HttpMethod.GET && rangeHeader.startsWith(UNIT_BYTES) && response.status() == HttpStatus.OK && (range = SystemFileBodyWriter.parseRangeHeader(rangeHeader, fileLength)) != null && range.firstPos < range.lastPos && range.firstPos < fileLength && range.lastPos < fileLength) {
                        position = range.firstPos;
                        contentLength = range.lastPos + 1L - range.firstPos;
                        response.status(HttpStatus.PARTIAL_CONTENT);
                        response.header("Content-Range", "%s %d-%d/%d".formatted(UNIT_BYTES, range.firstPos, range.lastPos, fileLength));
                    }
                    response.header("Accept-Ranges", UNIT_BYTES);
                    response.header("Content-Length", Long.toString(contentLength));
                } else {
                    response.header(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
                }
                DefaultHttpResponse finalResponse = new DefaultHttpResponse(nettyResponse.getNettyHttpVersion(), nettyResponse.getNettyHttpStatus(), nettyResponse.getNettyHeaders());
                SystemFileBodyWriter.writeFile(systemFile, nettyContext, position, contentLength, finalResponse);
            }
        } else {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
    }

    private static void writeFile(SystemFile systemFile, NettyWriteContext context, long position, long contentLength, DefaultHttpResponse finalResponse) {
        File file = systemFile.getFile();
        RandomAccessFile randomAccessFile = SystemFileBodyWriter.open(file);
        context.writeFile(finalResponse, randomAccessFile, position, contentLength);
    }

    private static RandomAccessFile open(File file) {
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new MessageBodyException("Could not find file", e);
        }
    }

    @Nullable
    private static IntRange parseRangeHeader(String value, long contentLength) {
        int equalsIdx = value.indexOf(61);
        if (equalsIdx < 0 || equalsIdx == value.length() - 1) {
            return null;
        }
        int minusIdx = value.indexOf(45, equalsIdx + 1);
        if (minusIdx < 0) {
            return null;
        }
        String from = value.substring(equalsIdx + 1, minusIdx).trim();
        String to = value.substring(minusIdx + 1).trim();
        try {
            long fromPosition = from.isEmpty() ? 0L : Long.parseLong(from);
            long toPosition = to.isEmpty() ? contentLength - 1L : Long.parseLong(to);
            return new IntRange(fromPosition, toPosition);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class IntRange {
        private final long firstPos;
        private final long lastPos;

        IntRange(long firstPos, long lastPos) {
            this.firstPos = firstPos;
            this.lastPos = lastPos;
        }
    }
}

