/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.UnsafeBeanInstantiationIntrospection;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringIntMap;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.annotation.EvaluatedAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractInitializableBeanIntrospection<B>
implements UnsafeBeanInstantiationIntrospection<B> {
    private final Class<B> beanType;
    private final AnnotationMetadata annotationMetadata;
    private final AnnotationMetadata constructorAnnotationMetadata;
    private final Argument<?>[] constructorArguments;
    private final BeanProperty<B, Object>[] beanProperties;
    private final List<BeanProperty<B, Object>> beanPropertiesList;
    private final List<BeanMethod<B, Object>> beanMethodsList;
    private final StringIntMap beanPropertyIndex;
    private BeanConstructor<B> beanConstructor;
    private IntrospectionBuilderData builderData;

    protected AbstractInitializableBeanIntrospection(Class<B> beanType, AnnotationMetadata annotationMetadata, AnnotationMetadata constructorAnnotationMetadata, Argument<?>[] constructorArguments, BeanPropertyRef<Object>[] propertiesRefs, BeanMethodRef<Object>[] methodsRefs) {
        this.beanType = beanType;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : EvaluatedAnnotationMetadata.wrapIfNecessary(annotationMetadata);
        AnnotationMetadata annotationMetadata2 = this.constructorAnnotationMetadata = constructorAnnotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : EvaluatedAnnotationMetadata.wrapIfNecessary(constructorAnnotationMetadata);
        if (this.hasBuilder()) {
            IntrospectionBuilderData bd = this.getBuilderData();
            this.constructorArguments = ArrayUtils.concat(bd.arguments, bd.creator.getArguments());
        } else {
            Argument[] argumentArray = this.constructorArguments = constructorArguments == null ? Argument.ZERO_ARGUMENTS : constructorArguments;
        }
        if (propertiesRefs != null) {
            ArrayList<BeanPropertyImpl<Object>> beanProperties = new ArrayList<BeanPropertyImpl<Object>>(propertiesRefs.length);
            for (BeanPropertyRef<Object> beanPropertyRef : propertiesRefs) {
                beanProperties.add(new BeanPropertyImpl<Object>(beanPropertyRef));
            }
            this.beanProperties = (BeanProperty[])beanProperties.toArray(BeanProperty[]::new);
            this.beanPropertiesList = Collections.unmodifiableList(beanProperties);
        } else {
            this.beanProperties = new BeanProperty[0];
            this.beanPropertiesList = Collections.emptyList();
        }
        this.beanPropertyIndex = new StringIntMap(this.beanProperties.length);
        for (int i = 0; i < this.beanProperties.length; ++i) {
            this.beanPropertyIndex.put(this.beanProperties[i].getName(), i);
        }
        if (methodsRefs != null) {
            ArrayList beanMethods = new ArrayList(methodsRefs.length);
            for (BeanMethodRef<Object> beanMethodRef : methodsRefs) {
                beanMethods.add(new BeanMethodImpl(beanMethodRef));
            }
            this.beanMethodsList = Collections.unmodifiableList(beanMethods);
        } else {
            this.beanMethodsList = Collections.emptyList();
        }
    }

    @Override
    public BeanIntrospection.Builder<B> builder() {
        if (this.isBuildable()) {
            return new IntrospectionBuilder(this);
        }
        throw new IntrospectionException("No accessible constructor or builder exists for type: " + this.getBeanType().getName());
    }

    @NonNull
    @Internal
    protected B instantiateInternal(@Nullable Object[] arguments) {
        if (this.hasBuilder() && arguments != null) {
            BeanIntrospection.Builder<B> b = this.builder();
            @NonNull Argument<?>[] args = b.getBuilderArguments();
            for (int i = 0; i < args.length; ++i) {
                Argument<?> arg = args[i];
                Object val = arguments[i];
                b.with(i, arg, val);
            }
            @NonNull Argument<?>[] buildMethodArguments = b.getBuildMethodArguments();
            if (buildMethodArguments.length == 0) {
                return b.build();
            }
            @Nullable Object[] buildParams = Arrays.copyOfRange(arguments, args.length, arguments.length);
            return b.build(buildParams);
        }
        throw new InstantiationException("Type [" + this.getBeanType() + "] defines no accessible constructor");
    }

    @Internal
    protected BeanProperty<B, Object> getPropertyByIndex(int index) {
        return this.beanProperties[index];
    }

    @Override
    public int propertyIndexOf(String name) {
        return this.beanPropertyIndex.get(name, -1);
    }

    @Internal
    protected abstract Method getTargetMethodByIndex(int var1);

    protected final Method getAccessibleTargetMethodByIndex(int index) {
        Method method = this.getTargetMethodByIndex(index);
        if (ClassUtils.REFLECTION_LOGGER.isDebugEnabled()) {
            ClassUtils.REFLECTION_LOGGER.debug("Reflectively accessing method {} of type {}", (Object)method, (Object)method.getDeclaringClass());
        }
        method.setAccessible(true);
        return method;
    }

    @Nullable
    protected <V> V dispatch(int index, @NonNull B target, @Nullable Object[] args) {
        throw this.unknownDispatchAtIndexException(index);
    }

    @Nullable
    protected <V> V dispatchOne(int index, @NonNull Object target, @Nullable Object arg) {
        throw this.unknownDispatchAtIndexException(index);
    }

    protected final RuntimeException unknownDispatchAtIndexException(int index) {
        return new IllegalStateException("Unknown dispatch at index: " + index);
    }

    @Nullable
    public BeanProperty<B, Object> findIndexedProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String annotationValue) {
        return null;
    }

    @Override
    @NonNull
    public Collection<BeanProperty<B, Object>> getIndexedProperties(@NonNull Class<? extends Annotation> annotationType) {
        return Collections.emptyList();
    }

    protected Collection<BeanProperty<B, Object>> getBeanPropertiesIndexedSubset(int[] indexes) {
        if (indexes.length == 0) {
            return Collections.emptyList();
        }
        return new IndexedCollections<BeanProperty<B, Object>>(indexes, this.beanProperties);
    }

    @Override
    public B instantiate() throws InstantiationException {
        throw new InstantiationException("No default constructor exists");
    }

    @Override
    @NonNull
    public B instantiate(boolean strictNullable, Object ... arguments) throws InstantiationException {
        ArgumentUtils.requireNonNull("arguments", arguments);
        if (arguments.length == 0) {
            return this.instantiate();
        }
        Argument<?>[] constructorArguments = this.getConstructorArguments();
        if (constructorArguments.length != arguments.length) {
            throw new InstantiationException("Argument count [" + arguments.length + "] doesn't match required argument count: " + constructorArguments.length);
        }
        for (int i = 0; i < constructorArguments.length; ++i) {
            Argument<?> constructorArgument = constructorArguments[i];
            Object specified = arguments[i];
            if (specified == null) {
                if (constructorArgument.isDeclaredNullable() || !strictNullable) continue;
                throw new InstantiationException("Null argument specified for [" + constructorArgument.getName() + "]. If this argument is allowed to be null annotate it with @Nullable");
            }
            if (ReflectionUtils.getWrapperType(constructorArgument.getType()).isInstance(specified)) continue;
            throw new InstantiationException("Invalid argument [" + specified + "] specified for argument: " + constructorArgument);
        }
        return this.instantiateInternal(arguments);
    }

    @Override
    public B instantiateUnsafe(Object ... arguments) {
        return this.instantiateInternal(arguments);
    }

    @Override
    public BeanConstructor<B> getConstructor() {
        if (this.beanConstructor == null) {
            this.beanConstructor = new BeanConstructor<B>(){

                @Override
                public Class<B> getDeclaringBeanType() {
                    return AbstractInitializableBeanIntrospection.this.beanType;
                }

                @Override
                public Argument<?>[] getArguments() {
                    return AbstractInitializableBeanIntrospection.this.constructorArguments;
                }

                @Override
                public B instantiate(Object ... parameterValues) {
                    return AbstractInitializableBeanIntrospection.this.instantiate(parameterValues);
                }

                @Override
                public AnnotationMetadata getAnnotationMetadata() {
                    return AbstractInitializableBeanIntrospection.this.constructorAnnotationMetadata;
                }
            };
        }
        return this.beanConstructor;
    }

    @Override
    public Argument<?>[] getConstructorArguments() {
        return this.constructorArguments;
    }

    @Override
    @NonNull
    public Optional<BeanProperty<B, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String annotationValue) {
        return Optional.ofNullable(this.findIndexedProperty(annotationType, annotationValue));
    }

    @Override
    @NonNull
    public Optional<BeanProperty<B, Object>> getProperty(@NonNull String name) {
        ArgumentUtils.requireNonNull("name", name);
        int index = this.propertyIndexOf(name);
        return index == -1 ? Optional.empty() : Optional.of(this.beanProperties[index]);
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @NonNull
    public Collection<BeanProperty<B, Object>> getBeanProperties() {
        return this.beanPropertiesList;
    }

    @Override
    @NonNull
    public Class<B> getBeanType() {
        return this.beanType;
    }

    @Override
    @NonNull
    public Collection<BeanMethod<B, Object>> getBeanMethods() {
        return this.beanMethodsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInitializableBeanIntrospection that = (AbstractInitializableBeanIntrospection)o;
        return Objects.equals(this.beanType, that.beanType);
    }

    public int hashCode() {
        return this.beanType.hashCode();
    }

    public String toString() {
        return "BeanIntrospection{type=" + this.beanType + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    private IntrospectionBuilderData getBuilderData() {
        if (this.builderData != null) return this.builderData;
        AnnotationValue builderAnn = this.getAnnotationMetadata().findAnnotation(Introspected.class).flatMap(a -> a.getAnnotation("builder", Introspected.IntrospectionBuilder.class)).orElse(null);
        if (builderAnn != null) {
            Class builderClass = this.getAnnotationMetadata().classValue(Introspected.class, "builderClass").orElse(null);
            if (builderClass == null) throw new IntrospectionException("Introspection defines invalid builder member for type: " + this.getBeanType());
            BeanIntrospection<Object> builderIntrospection = BeanIntrospection.getIntrospection(builderClass);
            Collection beanMethods = builderIntrospection.getBeanMethods();
            BeanMethod constructorMethod = beanMethods.stream().filter(m -> m.getReturnType().getType().equals(this.getBeanType())).findFirst().orElse(null);
            if (constructorMethod == null) {
                throw new IntrospectionException("No build method found in builder: " + builderClass.getName());
            }
            BeanMethod[] builderMethods = (BeanMethod[])beanMethods.stream().filter(m -> m.getReturnType().getType().isAssignableFrom(builderIntrospection.getBeanType())).toArray(BeanMethod[]::new);
            @NonNull Argument[] arguments = (Argument[])Arrays.stream(builderMethods).map(m -> {
                @NonNull Object[] methodArgs = m.getArguments();
                if (ArrayUtils.isNotEmpty(methodArgs)) {
                    return AbstractInitializableBeanIntrospection.toWrapperIfNecessary(methodArgs[0]);
                }
                return Argument.of(Boolean.class, m.getName());
            }).toArray(Argument[]::new);
            this.builderData = new IntrospectionBuilderData(builderIntrospection, constructorMethod, builderMethods, arguments);
            return this.builderData;
        } else {
            int constructorLength = this.constructorArguments.length;
            @NonNull UnsafeBeanProperty<P, Object>[] writeableProperties = this.resolveWriteableProperties(this.beanPropertiesList);
            this.builderData = new IntrospectionBuilderData(this.constructorArguments, constructorLength, writeableProperties);
        }
        return this.builderData;
    }

    @NonNull
    private static Argument<?> toWrapperIfNecessary(Argument<?> argument) {
        if (argument.isPrimitive()) {
            Class<?> wrapperType = argument.getWrapperType();
            return Argument.of(wrapperType, argument.getName(), argument.getAnnotationMetadata(), new Argument[0]);
        }
        return argument;
    }

    @NonNull
    private <P> UnsafeBeanProperty<P, Object>[] resolveWriteableProperties(Collection<BeanProperty<P, Object>> beanProperties) {
        return (UnsafeBeanProperty[])beanProperties.stream().filter(bp -> !bp.isReadOnly() && Arrays.stream(this.constructorArguments).noneMatch(a -> bp.getName().equals(a.getName()))).map(bp -> (UnsafeBeanProperty)bp).toArray(UnsafeBeanProperty[]::new);
    }

    private record IntrospectionBuilderData(Argument<?>[] arguments, int constructorLength, @Nullable UnsafeBeanProperty<Object, Object>[] writeableProperties, @Nullable BeanIntrospection<Object> builder, @Nullable BeanMethod<Object, Object> creator, @Nullable BeanMethod<Object, Object>[] buildMethods, StringIntMap argumentIndex, Object[] defaultValues, boolean[] required) {
        public IntrospectionBuilderData(Argument<?>[] constructorArguments, int constructorLength, UnsafeBeanProperty<Object, Object>[] writeableProperties) {
            this(IntrospectionBuilderData.toArguments(constructorArguments, constructorLength, writeableProperties), constructorLength, writeableProperties, null, null, null, new StringIntMap(constructorLength + writeableProperties.length), new Object[constructorLength + writeableProperties.length], IntrospectionBuilderData.toRequires(constructorLength, constructorArguments, writeableProperties));
            this.init(this.arguments);
        }

        public IntrospectionBuilderData(BeanIntrospection<Object> builder, BeanMethod<Object, Object> creator, BeanMethod<Object, Object>[] buildMethods, Argument<?>[] arguments) {
            this(arguments, 0, null, builder, creator, buildMethods, new StringIntMap(arguments.length), new Object[arguments.length], new boolean[arguments.length]);
            this.init(arguments);
        }

        @NonNull
        private static boolean[] toRequires(int constructorLength, Argument<?>[] constructorArguments, UnsafeBeanProperty<Object, Object>[] writeableProperties) {
            int i;
            boolean[] requires = new boolean[constructorLength + writeableProperties.length];
            for (i = 0; i < constructorLength; ++i) {
                Argument<?> argument = constructorArguments[i];
                requires[i] = argument.getType().isPrimitive() || argument.isDeclaredNonNull();
            }
            for (i = constructorLength; i < requires.length; ++i) {
                UnsafeBeanProperty<Object, Object> writeableProperty = writeableProperties[i - constructorLength];
                Argument argument = writeableProperty.asArgument();
                requires[i] = argument.getType().isPrimitive() || argument.isDeclaredNonNull();
            }
            return requires;
        }

        static Argument<?>[] toArguments(Argument<?>[] constructorArguments, int constructorLength, UnsafeBeanProperty<Object, Object>[] writeableProperties) {
            Argument<?>[] arguments;
            Argument<?>[] propertyArguments = IntrospectionBuilderData.toArguments(writeableProperties);
            if (constructorLength == 0) {
                arguments = propertyArguments;
            } else {
                Argument[] newConstructorArguments = new Argument[constructorLength];
                for (int i = 0; i < constructorLength; ++i) {
                    Argument<?> argument;
                    Argument<?> constructorArgument = constructorArguments[i];
                    newConstructorArguments[i] = argument = AbstractInitializableBeanIntrospection.toWrapperIfNecessary(constructorArgument);
                }
                arguments = ArrayUtils.concat(newConstructorArguments, propertyArguments);
            }
            return arguments;
        }

        @NonNull
        private static Argument<?>[] toArguments(BeanProperty<?, ?>[] writeableProperties) {
            return (Argument[])Arrays.stream(writeableProperties).map(bp -> {
                Argument argument = bp.asArgument();
                return AbstractInitializableBeanIntrospection.toWrapperIfNecessary(argument);
            }).toArray(Argument[]::new);
        }

        private void init(Argument<?>[] arguments) {
            for (int i = 0; i < arguments.length; ++i) {
                Argument<?> argument = arguments[i];
                this.argumentIndex.put(argument.getName(), i);
                this.defaultValues[i] = argument.getAnnotationMetadata().getValue(Bindable.class, "defaultValue", argument).orElse(null);
            }
        }
    }

    private final class BeanPropertyImpl<P>
    implements UnsafeBeanProperty<B, P> {
        private final BeanPropertyRef<P> ref;
        private final Class<?> typeOrWrapperType;
        private final AnnotationMetadata annotationMetadata;

        private BeanPropertyImpl(BeanPropertyRef<P> ref) {
            this.ref = ref;
            this.typeOrWrapperType = ReflectionUtils.getWrapperType(this.getType());
            this.annotationMetadata = EvaluatedAnnotationMetadata.wrapIfNecessary(ref.argument.getAnnotationMetadata());
        }

        @Override
        @NonNull
        public String getName() {
            return this.ref.argument.getName();
        }

        @Override
        @NonNull
        public Class<P> getType() {
            return this.ref.argument.getType();
        }

        @Override
        @NonNull
        public Argument<P> asArgument() {
            return this.ref.argument;
        }

        @Override
        @NonNull
        public BeanIntrospection<B> getDeclaringBean() {
            return AbstractInitializableBeanIntrospection.this;
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            return this.annotationMetadata;
        }

        @Override
        @Nullable
        public P get(@NonNull B bean) {
            ArgumentUtils.requireNonNull("bean", bean);
            if (!AbstractInitializableBeanIntrospection.this.beanType.isInstance(bean)) {
                throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + AbstractInitializableBeanIntrospection.this.beanType);
            }
            if (this.isWriteOnly()) {
                throw new UnsupportedOperationException("Cannot read from a write-only property: " + this.getName());
            }
            return (P)AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.getMethodIndex, bean, null);
        }

        @Override
        public P getUnsafe(B bean) {
            return (P)AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.getMethodIndex, bean, null);
        }

        @Override
        public void set(@NonNull B bean, @Nullable P value) {
            ArgumentUtils.requireNonNull("bean", bean);
            if (!AbstractInitializableBeanIntrospection.this.beanType.isInstance(bean)) {
                throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + bean);
            }
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException("Cannot write a read-only property: " + this.getName());
            }
            if (value != null && !this.typeOrWrapperType.isInstance(value)) {
                throw new IllegalArgumentException("Specified value [" + value + "] is not of the correct type: " + this.getType());
            }
            AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.setMethodIndex, bean, value);
        }

        @Override
        public void setUnsafe(B bean, P value) {
            AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.setMethodIndex, bean, value);
        }

        @Override
        public B withValue(@NonNull B bean, @Nullable P value) {
            ArgumentUtils.requireNonNull("bean", bean);
            if (!AbstractInitializableBeanIntrospection.this.beanType.isInstance(bean)) {
                throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + AbstractInitializableBeanIntrospection.this.beanType);
            }
            return this.withValueUnsafe((B)bean, value);
        }

        @Override
        public B withValueUnsafe(B bean, P value) {
            if (value == this.getUnsafe(bean)) {
                return bean;
            }
            if (this.ref.withMethodIndex == -1) {
                if (!this.ref.readyOnly && this.ref.setMethodIndex != -1) {
                    AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.setMethodIndex, bean, value);
                    return bean;
                }
                return UnsafeBeanProperty.super.withValue(bean, value);
            }
            return AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.withMethodIndex, bean, value);
        }

        @Override
        public boolean isReadOnly() {
            return this.ref.readyOnly;
        }

        @Override
        public boolean isWriteOnly() {
            return this.ref.getMethodIndex == -1 && (this.ref.setMethodIndex != -1 || this.ref.withMethodIndex != -1);
        }

        @Override
        public boolean hasSetterOrConstructorArgument() {
            return this.ref.mutable;
        }

        public String toString() {
            return "BeanProperty{beanType=" + AbstractInitializableBeanIntrospection.this.beanType + ", type=" + this.ref.argument.getType() + ", name='" + this.ref.argument.getName() + "'}";
        }
    }

    @Internal
    public static final class BeanPropertyRef<P> {
        @NonNull
        final Argument<P> argument;
        final int getMethodIndex;
        final int setMethodIndex;
        final int withMethodIndex;
        final boolean readyOnly;
        final boolean mutable;

        public BeanPropertyRef(@NonNull Argument<P> argument, int getMethodIndex, int setMethodIndex, int valueMethodIndex, boolean readyOnly, boolean mutable) {
            this.argument = argument;
            this.getMethodIndex = getMethodIndex;
            this.setMethodIndex = setMethodIndex;
            this.withMethodIndex = valueMethodIndex;
            this.readyOnly = readyOnly;
            this.mutable = mutable;
        }
    }

    private final class BeanMethodImpl<P>
    implements BeanMethod<B, P>,
    ExecutableMethod<B, P> {
        private final BeanMethodRef<P> ref;

        private BeanMethodImpl(BeanMethodRef<P> ref) {
            this.ref = ref;
        }

        @Override
        @NonNull
        public BeanIntrospection<B> getDeclaringBean() {
            return AbstractInitializableBeanIntrospection.this;
        }

        @Override
        @NonNull
        public ReturnType<P> getReturnType() {
            return new ReturnType(){

                @Override
                public Class<P> getType() {
                    return BeanMethodImpl.this.ref.returnType.getType();
                }

                @Override
                @NonNull
                public Argument<P> asArgument() {
                    return BeanMethodImpl.this.ref.returnType;
                }

                @Override
                public Map<String, Argument<?>> getTypeVariables() {
                    return BeanMethodImpl.this.ref.returnType.getTypeVariables();
                }

                @Override
                @NonNull
                public AnnotationMetadata getAnnotationMetadata() {
                    return EvaluatedAnnotationMetadata.wrapIfNecessary(BeanMethodImpl.this.ref.returnType.getAnnotationMetadata());
                }
            };
        }

        @Override
        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            return this.ref.annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : this.ref.annotationMetadata;
        }

        @Override
        @NonNull
        public String getName() {
            return this.ref.name;
        }

        @Override
        public Argument<?>[] getArguments() {
            return this.ref.arguments == null ? Argument.ZERO_ARGUMENTS : this.ref.arguments;
        }

        @Override
        public P invoke(@NonNull B instance, Object ... arguments) {
            return (P)AbstractInitializableBeanIntrospection.this.dispatch(this.ref.methodIndex, instance, arguments);
        }

        @Override
        public Method getTargetMethod() {
            if (ClassUtils.REFLECTION_LOGGER.isWarnEnabled()) {
                ClassUtils.REFLECTION_LOGGER.warn("Using getTargetMethod for method {} on type {} requires the use of reflection. GraalVM configuration necessary", (Object)this.getName(), (Object)this.getDeclaringType());
            }
            return AbstractInitializableBeanIntrospection.this.getTargetMethodByIndex(this.ref.methodIndex);
        }

        @Override
        public Class<B> getDeclaringType() {
            return this.getDeclaringBean().getBeanType();
        }

        @Override
        public String getMethodName() {
            return this.getName();
        }
    }

    @Internal
    public static final class BeanMethodRef<P> {
        @NonNull
        final Argument<P> returnType;
        @NonNull
        final String name;
        @Nullable
        final AnnotationMetadata annotationMetadata;
        @Nullable
        final Argument<?>[] arguments;
        final int methodIndex;

        public BeanMethodRef(@NonNull Argument<P> returnType, @NonNull String name, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument<?>[] arguments, int methodIndex) {
            this.returnType = returnType;
            this.name = name;
            this.annotationMetadata = EvaluatedAnnotationMetadata.wrapIfNecessary(annotationMetadata);
            this.arguments = arguments;
            this.methodIndex = methodIndex;
        }
    }

    private static final class IntrospectionBuilder<B>
    implements BeanIntrospection.Builder<B> {
        private static final Object[] NULL_ARG = new Object[]{null};
        private final Object[] params;
        private final IntrospectionBuilderData builderData;
        private final AbstractInitializableBeanIntrospection<B> introspection;

        IntrospectionBuilder(AbstractInitializableBeanIntrospection<B> outer) {
            IntrospectionBuilderData data = outer.getBuilderData();
            this.introspection = outer;
            this.builderData = data;
            this.params = new Object[data.arguments.length];
        }

        @Override
        @NonNull
        public Argument<?>[] getBuilderArguments() {
            return this.builderData.arguments;
        }

        @Override
        @NonNull
        public Argument<?>[] getBuildMethodArguments() {
            return this.builderData.creator.getArguments();
        }

        @Override
        public int indexOf(String name) {
            return this.builderData.argumentIndex.get(name, -1);
        }

        @Override
        @NonNull
        public BeanIntrospection.Builder<B> with(String name, Object value) {
            int i = this.indexOf(name);
            if (i != -1) {
                Argument<?> argument = this.builderData.arguments[i];
                return this.with(i, argument, value);
            }
            return this;
        }

        @Override
        @NonNull
        public <A> BeanIntrospection.Builder<B> with(int index, Argument<A> argument, A value) {
            if (value != null) {
                if (!argument.isInstance(value)) {
                    throw new IllegalArgumentException("Invalid value [" + value + "] specified for argument [" + argument + "]");
                }
                this.params[index] = value;
            }
            return this;
        }

        @Override
        @NonNull
        public <A> BeanIntrospection.Builder<B> convert(int index, ArgumentConversionContext<A> conversionContext, Object value, ConversionService conversionService) {
            Argument<A> argument = conversionContext.getArgument();
            if (value != null) {
                if (!argument.isInstance(value)) {
                    value = conversionService.convertRequired(value, conversionContext);
                }
                this.params[index] = value;
            }
            return this;
        }

        @Override
        public BeanIntrospection.Builder<B> with(B existing) {
            if (existing != null) {
                Collection<BeanProperty<B, Object>> properties = this.introspection.getBeanProperties();
                for (BeanProperty<B, Object> property : properties) {
                    int i;
                    if (property.isWriteOnly() || !property.hasSetterOrConstructorArgument() || (i = this.indexOf(property.getName())) <= -1) continue;
                    this.with(i, this.builderData.arguments[i], property.get(existing));
                }
            }
            return this;
        }

        @Override
        public B build() {
            return this.build(ArrayUtils.EMPTY_OBJECT_ARRAY);
        }

        @Override
        public B build(Object ... builderParams) {
            for (int i = 0; i < this.builderData.required.length; ++i) {
                if (!this.builderData.required[i] || this.params[i] != null) continue;
                throw new IllegalArgumentException("Non-null argument [" + this.builderData.arguments[i] + "] specified as a null");
            }
            BeanIntrospection<Object> builderIntrospection = this.builderData.builder;
            if (builderIntrospection != null) {
                Object b = builderIntrospection.instantiate();
                BeanMethod<Object, Object> creator = this.builderData.creator;
                for (int i = 0; i < this.params.length; ++i) {
                    Object r;
                    Object param = this.params[i];
                    BeanMethod<Object, Object> m = this.builderData.buildMethods[i];
                    if (param instanceof Boolean) {
                        Boolean bool = (Boolean)param;
                        if (m.getArguments().length == 0) {
                            if (!Boolean.TRUE.equals(bool) || (r = m.invoke(b, new Object[0])) == null) continue;
                            b = r;
                            continue;
                        }
                        r = m.invoke(b, bool);
                        if (r == null) continue;
                        b = r;
                        continue;
                    }
                    r = null;
                    if (param != null) {
                        r = m.invoke(b, param);
                    } else if (this.builderData.arguments[i].isDeclaredNullable()) {
                        r = m.invoke(b, NULL_ARG);
                    }
                    if (r == null) continue;
                    b = r;
                }
                if (creator.getArguments().length != builderParams.length) {
                    throw new InstantiationException("Build method " + creator + " expects [" + creator.getArguments().length + "] arguments, but " + builderParams.length + " were provided");
                }
                return (B)creator.invoke(b, builderParams);
            }
            int constructorLength = this.builderData.constructorLength;
            if (constructorLength == this.params.length) {
                return this.introspection.instantiateInternal(this.params);
            }
            Object[] constructorParams = Arrays.copyOfRange(this.params, 0, constructorLength);
            B bean = this.introspection.instantiateInternal(constructorParams);
            UnsafeBeanProperty<Object, Object>[] writeableProperties = this.builderData.writeableProperties;
            if (writeableProperties != null) {
                for (int i = constructorLength; i < this.builderData.arguments.length; ++i) {
                    UnsafeBeanProperty<Object, Object> property = writeableProperties[i - constructorLength];
                    Object v = this.params[i];
                    property.setUnsafe(bean, v);
                }
            }
            return bean;
        }
    }

    private static final class IndexedCollections<T>
    extends AbstractCollection<T> {
        private final int[] indexed;
        private final T[] array;

        private IndexedCollections(int[] indexed, T[] array) {
            this.indexed = indexed;
            this.array = array;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int i = -1;

                @Override
                public boolean hasNext() {
                    return this.i + 1 < indexed.length;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int index = indexed[++this.i];
                    return array[index];
                }
            };
        }

        @Override
        public int size() {
            return this.indexed.length;
        }
    }
}

