/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.http.codec;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Singleton
@BootstrapContextCompatible
public class TextPlainCodec
implements MediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "text";
    private final Charset defaultCharset;
    private final List<MediaType> additionalTypes;
    private final ConversionService conversionService;

    @Inject
    public TextPlainCodec(@Value(value="${micronaut.application.default-charset}") Optional<Charset> defaultCharset, @Named(value="text") @Nullable CodecConfiguration codecConfiguration, ConversionService conversionService) {
        this.defaultCharset = defaultCharset.orElse(StandardCharsets.UTF_8);
        this.conversionService = conversionService;
        this.additionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    public TextPlainCodec(Charset defaultCharset, ConversionService conversionService) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : StandardCharsets.UTF_8;
        this.conversionService = conversionService;
        this.additionalTypes = Collections.emptyList();
    }

    @Override
    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(this.additionalTypes.size() + 1);
        mediaTypes.add(MediaType.TEXT_PLAIN_TYPE);
        mediaTypes.addAll(this.additionalTypes);
        return mediaTypes;
    }

    @Override
    public <T> T decode(Argument<T> type, ByteBuffer<?> buffer) throws CodecException {
        String text = buffer.toString(this.defaultCharset);
        if (CharSequence.class.isAssignableFrom(type.getType())) {
            return (T)text;
        }
        return this.conversionService.convert((Object)text, type).orElseThrow(() -> new CodecException("Cannot decode byte buffer with value [" + text + "] to type: " + type));
    }

    @Override
    public <T> T decode(Argument<T> type, byte[] bytes) throws CodecException {
        String text = new String(bytes, this.defaultCharset);
        if (CharSequence.class.isAssignableFrom(type.getType())) {
            return (T)text;
        }
        return this.conversionService.convert((Object)text, type).orElseThrow(() -> new CodecException("Cannot decode bytes with value [" + text + "] to type: " + type));
    }

    @Override
    public <T> T decode(Argument<T> type, InputStream inputStream) throws CodecException {
        if (CharSequence.class.isAssignableFrom(type.getType())) {
            try {
                return (T)IOUtils.readText(new BufferedReader(new InputStreamReader(inputStream, this.defaultCharset)));
            }
            catch (IOException e) {
                throw new CodecException("Error decoding string from stream: " + e.getMessage());
            }
        }
        throw new UnsupportedOperationException("codec only supports decoding objects to string");
    }

    @Override
    public <T> void encode(T object, OutputStream outputStream) throws CodecException {
        byte[] bytes = this.encode(object);
        try {
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new CodecException("Error writing encoding bytes to stream: " + e.getMessage(), e);
        }
    }

    @Override
    public <T> byte[] encode(T object) throws CodecException {
        return object.toString().getBytes(this.defaultCharset);
    }

    @Override
    public <T, B> ByteBuffer<B> encode(T object, ByteBufferFactory<?, B> allocator) throws CodecException {
        byte[] bytes = this.encode(object);
        return allocator.wrap(bytes);
    }
}

