/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.LoomSupport;
import io.micronaut.scheduling.executor.ExecutorConfiguration;
import io.micronaut.scheduling.executor.ExecutorType;
import io.micronaut.scheduling.executor.UserExecutorConfiguration;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;

@Factory
public final class IOExecutorServiceConfig {
    @Singleton
    @Named(value="io")
    @Requires(missingProperty="micronaut.executors.io")
    ExecutorConfiguration io() {
        return UserExecutorConfiguration.of("io", ExecutorType.CACHED);
    }

    @Singleton
    @Named(value="virtual")
    @Requires(missingProperty="micronaut.executors.virtual", condition=LoomSupport.LoomCondition.class)
    ExecutorConfiguration virtual() {
        LoomSupport.checkSupported();
        UserExecutorConfiguration cfg = UserExecutorConfiguration.of("virtual", ExecutorType.THREAD_PER_TASK);
        cfg.setVirtual(true);
        return cfg;
    }

    @Singleton
    @Named(value="blocking")
    @Requires(missingProperty="micronaut.executors.blocking")
    ExecutorService blocking(@Named(value="io") BeanProvider<ExecutorService> io, @Named(value="virtual") BeanProvider<ExecutorService> virtual) {
        if (virtual.isPresent()) {
            return virtual.get();
        }
        return io.get();
    }
}

