/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import java.io.IOException;

@Internal
final class DelegatingObjectDeserializer
implements Deserializer<Object> {
    private final boolean strictNullable;
    private final DeserBean<? super Object> deserBean;
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;

    public DelegatingObjectDeserializer(boolean strictNullable, DeserBean<? super Object> deserBean, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.strictNullable = strictNullable;
        this.deserBean = deserBean;
        this.preInstantiateCallback = preInstantiateCallback;
    }

    @Override
    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        if (this.deserBean.creatorParams != null) {
            Object result;
            PropertiesBag.Consumer creatorParams = this.deserBean.creatorParams.newConsumer();
            DeserBean.DerProperty creator = creatorParams.getNotConsumed().iterator().next();
            try {
                Deserializer deserializer = creator.deserializer;
                result = deserializer.deserializeNullable(decoder, decoderContext, creator.argument);
            }
            catch (InvalidFormatException e) {
                throw new InvalidPropertyFormatException(e, creator.argument);
            }
            Object[] args = new Object[]{result};
            if (this.preInstantiateCallback != null) {
                this.preInstantiateCallback.preInstantiate(this.deserBean.introspection, args);
            }
            return this.deserBean.introspection.instantiate(this.strictNullable, args);
        }
        throw new IllegalStateException("At least one creator parameter expected");
    }

    @Override
    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }
}

