/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.config.DeserializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DelegatingObjectDeserializer;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanKey;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.deserializers.DeserializationSerdeArgumentConf;
import io.micronaut.serde.support.deserializers.SerdeDeserializationPreInstantiateCallback;
import io.micronaut.serde.support.deserializers.SimpleObjectDeserializer;
import io.micronaut.serde.support.deserializers.SimpleRecordLikeObjectDeserializer;
import io.micronaut.serde.support.deserializers.SpecificObjectDeserializer;
import io.micronaut.serde.support.deserializers.SubtypeInfo;
import io.micronaut.serde.support.deserializers.SubtypedPropertyObjectDeserializer;
import io.micronaut.serde.support.deserializers.WrappedObjectDeserializer;
import io.micronaut.serde.support.deserializers.WrappedObjectSubtypedDeserializer;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Singleton
@Primary
@BootstrapContextCompatible
public class ObjectDeserializer
implements CustomizableDeserializer<Object>,
DeserBeanRegistry {
    private final SerdeIntrospections introspections;
    private final DeserializationConfiguration deserializationConfiguration;
    private final Map<DeserBeanKey, Supplier<DeserBean<?>>> deserBeanMap = new ConcurrentHashMap(50);
    @Nullable
    private final SerdeDeserializationPreInstantiateCallback preInstantiateCallback;

    public ObjectDeserializer(SerdeIntrospections introspections, DeserializationConfiguration deserializationConfiguration, @Nullable SerdeDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.introspections = introspections;
        this.deserializationConfiguration = deserializationConfiguration;
        this.preInstantiateCallback = preInstantiateCallback;
    }

    @Override
    public Deserializer<Object> createSpecific(Deserializer.DecoderContext context, Argument<? super Object> type) throws SerdeException {
        if (type.equalsType(Argument.OBJECT_ARGUMENT)) {
            return (decoder, context1, type1) -> decoder.decodeArbitrary();
        }
        DeserBean<? super Object> deserBean = this.getDeserializableBean(type, context);
        if (deserBean.subtypeInfo != null) {
            SubtypeInfo subtypeInfo = deserBean.subtypeInfo;
            HashMap<String, Deserializer<Object>> subtypeDeserializers = CollectionUtils.newHashMap(subtypeInfo.subtypes().size());
            for (Map.Entry e : subtypeInfo.subtypes().entrySet()) {
                subtypeDeserializers.put(e.getKey(), this.findDeserializer(e.getValue(), true));
            }
            Deserializer<Object> supertypeDeserializer = this.findDeserializer(deserBean, false);
            if (subtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_OBJECT) {
                return new WrappedObjectSubtypedDeserializer(subtypeDeserializers, deserBean.ignoreUnknown);
            }
            if (subtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY) {
                return new SubtypedPropertyObjectDeserializer(deserBean, subtypeDeserializers, supertypeDeserializer, subtypeInfo.discriminatorVisible());
            }
            throw new IllegalStateException("Unrecognized discriminator type: " + subtypeInfo.discriminatorType());
        }
        return this.findDeserializer(deserBean, false);
    }

    private Deserializer<Object> findDeserializer(DeserBean<? super Object> deserBean, boolean isSubtype) {
        Deserializer<Object> deserializer = deserBean.simpleBean ? new SimpleObjectDeserializer(this.deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback) : (deserBean.recordLikeBean ? new SimpleRecordLikeObjectDeserializer(this.deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback) : (deserBean.delegating ? new DelegatingObjectDeserializer(this.deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback) : new SpecificObjectDeserializer(this.deserializationConfiguration.isStrictNullable(), deserBean, this.preInstantiateCallback)));
        if (!isSubtype && deserBean.wrapperProperty != null) {
            deserializer = new WrappedObjectDeserializer(deserializer, deserBean.wrapperProperty, deserBean.ignoreUnknown);
        }
        return deserializer;
    }

    @Override
    public <T> DeserBean<T> getDeserializableBean(Argument<T> type, Deserializer.DecoderContext decoderContext) throws SerdeException {
        DeserializationSerdeArgumentConf serdeArgumentConf = type.getAnnotationMetadata().isEmpty() ? null : new DeserializationSerdeArgumentConf(type.getAnnotationMetadata());
        DeserBeanKey key = new DeserBeanKey(type, serdeArgumentConf);
        Supplier deserBeanSupplier = this.deserBeanMap.computeIfAbsent(key, ignore -> SupplierUtil.memoizedNonEmpty(() -> this.createDeserBean(type, serdeArgumentConf, decoderContext)));
        DeserBean deserBean = (DeserBean)deserBeanSupplier.get();
        deserBean.initialize(decoderContext);
        return deserBean;
    }

    private <T> DeserBean<T> createDeserBean(Argument<T> type, @Nullable DeserializationSerdeArgumentConf serdeArgumentConf, Deserializer.DecoderContext decoderContext) {
        try {
            BeanIntrospection<T> deserializableIntrospection = this.introspections.getDeserializableIntrospection(type);
            return new DeserBean<T>(this.deserializationConfiguration, type, deserializableIntrospection, decoderContext, this, serdeArgumentConf);
        }
        catch (SerdeException e) {
            throw new IntrospectionException("Error creating deserializer for type [" + type + "]: " + e.getMessage(), e);
        }
    }
}

