/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Internal
record SubtypeInfo<T>(@NonNull Map<String, DeserBean<? extends T>> subtypes, @NonNull SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType, @NonNull String discriminatorName, @Nullable String defaultImpl, boolean discriminatorVisible) {
    static <T> SubtypeInfo<T> create(AnnotationMetadata annotationMetadata, BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        if (!annotationMetadata.hasAnnotation(SerdeConfig.SerSubtyped.class)) {
            return null;
        }
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = annotationMetadata.enumValue(SerdeConfig.SerSubtyped.class, "dt", SerdeConfig.SerSubtyped.DiscriminatorType.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY);
        SerdeConfig.SerSubtyped.DiscriminatorValueKind discriminatorValue = annotationMetadata.enumValue(SerdeConfig.SerSubtyped.class, "dv", SerdeConfig.SerSubtyped.DiscriminatorValueKind.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME);
        String discriminatorName = annotationMetadata.stringValue(SerdeConfig.SerSubtyped.class, "dp").orElse(discriminatorValue == SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME ? "@class" : "@type");
        Class<T> superType = introspection.getBeanType();
        Collection<BeanIntrospection<T>> subtypeIntrospections = decoderContext.getDeserializableSubtypes(superType);
        HashMap subtypes = CollectionUtils.newHashMap(subtypeIntrospections.size());
        Class defaultType = annotationMetadata.classValue(DefaultImplementation.class).orElse(null);
        String defaultDiscriminator = null;
        for (BeanIntrospection<T> subtypeIntrospection : subtypeIntrospections) {
            String[] names;
            Class<T> subBeanType = subtypeIntrospection.getBeanType();
            DeserBean deserBean = deserBeanRegistry.getDeserializableBean(Argument.of(subBeanType), decoderContext);
            if (defaultType != null && defaultType.equals(subBeanType)) {
                defaultDiscriminator = subtypeIntrospection.stringValue(SerdeConfig.class, "typeName").orElseThrow();
            }
            subtypeIntrospection.stringValue(SerdeConfig.class, "typeName").ifPresent(name -> subtypes.put((String)name, deserBean));
            for (String name2 : names = subtypeIntrospection.stringValues(SerdeConfig.class, "typeNames")) {
                subtypes.put(name2, deserBean);
            }
        }
        return new SubtypeInfo<T>(subtypes, discriminatorType, discriminatorName, defaultDiscriminator, annotationMetadata.booleanValue(SerdeConfig.SerSubtyped.class, "discriminatorVisible").orElse(false));
    }
}

