/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.collect.ArrayDequeDeserializer;
import io.micronaut.serde.support.deserializers.collect.ArrayListDeserializer;
import io.micronaut.serde.support.deserializers.collect.HashSetDeserializer;
import io.micronaut.serde.support.deserializers.collect.LinkedHashMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.LinkedHashSetDeserializer;
import io.micronaut.serde.support.deserializers.collect.LinkedListDeserializer;
import io.micronaut.serde.support.deserializers.collect.StringListDeserializer;
import io.micronaut.serde.support.deserializers.collect.TreeMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.TreeSetDeserializer;
import io.micronaut.serde.util.CustomizableDeserializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@Factory
@BootstrapContextCompatible
public class CoreCollectionsDeserializers {
    @Singleton
    @Order(value=-100)
    @NonNull
    protected <E> Deserializer<ArrayList<E>> arrayListDeserializer() {
        return new SpecificOnlyCollectionDeserializer<E, ArrayList<E>>(){

            @Override
            protected Deserializer<ArrayList<E>> createSpecific(Argument<? super ArrayList<E>> collectionArgument, Argument<E> collectionItemArgument, Deserializer<? extends E> valueDeser) {
                if (collectionArgument.getType().isAssignableFrom(ArrayList.class) && collectionItemArgument.getType().equals(String.class)) {
                    return StringListDeserializer.INSTANCE;
                }
                return new ArrayListDeserializer(valueDeser, collectionItemArgument);
            }
        };
    }

    @Singleton
    @Order(value=-99)
    @NonNull
    protected <E> Deserializer<ArrayDeque<E>> arrayDequeDeserializer() {
        return new SpecificOnlyCollectionDeserializer<E, ArrayDeque<E>>(){

            @Override
            protected Deserializer<ArrayDeque<E>> createSpecific(Argument<? super ArrayDeque<E>> collectionArgument, Argument<E> collectionItemArgument, Deserializer<? extends E> valueDeser) {
                return new ArrayDequeDeserializer(valueDeser, collectionItemArgument);
            }
        };
    }

    @Singleton
    @Order(value=-99)
    @NonNull
    protected <E> Deserializer<LinkedList<E>> linkedListDeserializer() {
        return new SpecificOnlyCollectionDeserializer<E, LinkedList<E>>(){

            @Override
            protected Deserializer<LinkedList<E>> createSpecific(Argument<? super LinkedList<E>> collectionArgument, Argument<E> collectionItemArgument, Deserializer<? extends E> valueDeser) {
                return new LinkedListDeserializer(valueDeser, collectionItemArgument);
            }
        };
    }

    @NonNull
    @Singleton
    @Order(value=-50)
    protected <E> Deserializer<HashSet<E>> hashSetDeserializer() {
        return new SpecificOnlyCollectionDeserializer<E, HashSet<E>>(){

            @Override
            protected Deserializer<HashSet<E>> createSpecific(Argument<? super HashSet<E>> collectionArgument, Argument<E> collectionItemArgument, Deserializer<? extends E> valueDeser) {
                return new HashSetDeserializer(valueDeser, collectionItemArgument);
            }
        };
    }

    @NonNull
    @Singleton
    protected <E> Deserializer<? extends Set<E>> defaultSetDeserializer() {
        return this.hashSetDeserializer();
    }

    @NonNull
    @Singleton
    @Order(value=-51)
    protected <E> Deserializer<LinkedHashSet<E>> linkedHashSetDeserializer() {
        return new SpecificOnlyCollectionDeserializer<E, LinkedHashSet<E>>(){

            @Override
            protected Deserializer<LinkedHashSet<E>> createSpecific(Argument<? super LinkedHashSet<E>> collectionArgument, Argument<E> collectionItemArgument, Deserializer<? extends E> valueDeser) {
                return new LinkedHashSetDeserializer(valueDeser, collectionItemArgument);
            }
        };
    }

    @NonNull
    @Singleton
    @Order(value=-52)
    protected <E> Deserializer<TreeSet<E>> treeSetDeserializer() {
        return new SpecificOnlyCollectionDeserializer<E, TreeSet<E>>(){

            @Override
            protected Deserializer<TreeSet<E>> createSpecific(Argument<? super TreeSet<E>> collectionArgument, Argument<E> collectionItemArgument, Deserializer<? extends E> valueDeser) {
                return new TreeSetDeserializer(valueDeser, collectionItemArgument);
            }
        };
    }

    @Singleton
    @NonNull
    @Order(value=1001)
    protected <K, V> Deserializer<LinkedHashMap<K, V>> linkedHashMapDeserializer() {
        return new SpecificOnlyMapDeserializer<K, V, LinkedHashMap<K, V>>(){

            @Override
            protected Deserializer<LinkedHashMap<K, V>> createSpecific(Argument<K> keyType, Argument<V> valueType, Deserializer<? extends V> valueDeser) {
                return new LinkedHashMapDeserializer(valueDeser, keyType, valueType);
            }
        };
    }

    @Singleton
    @NonNull
    @Order(value=1002)
    protected <K, V> Deserializer<TreeMap<K, V>> treeMapDeserializer() {
        return new SpecificOnlyMapDeserializer<K, V, TreeMap<K, V>>(){

            @Override
            protected Deserializer<TreeMap<K, V>> createSpecific(Argument<K> keyType, Argument<V> valueType, Deserializer<? extends V> valueDeser) {
                return new TreeMapDeserializer(valueDeser, keyType, valueType);
            }
        };
    }

    @Singleton
    @NonNull
    protected <V> Deserializer<Optional<V>> optionalDeserializer() {
        return new OptionalDeserializer();
    }

    private static class OptionalDeserializer<V>
    implements CustomizableDeserializer<Optional<V>> {
        private OptionalDeserializer() {
        }

        @Override
        public Deserializer<Optional<V>> createSpecific(Deserializer.DecoderContext context, Argument<? super Optional<V>> type) throws SerdeException {
            final Argument generic2 = type.getFirstTypeVariable().orElse(null);
            if (generic2 == null) {
                throw new SerdeException("Cannot deserialize raw optional");
            }
            final Deserializer deserializer = context.findDeserializer(generic2).createSpecific(context, generic2);
            return new Deserializer<Optional<V>>(){

                @Override
                public Optional<V> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Optional<V>> type) throws IOException {
                    if (decoder.decodeNull()) {
                        return Optional.empty();
                    }
                    return Optional.ofNullable(deserializer.deserialize(decoder, context, generic2));
                }

                @Override
                public Optional<V> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Optional<V>> type) throws IOException {
                    return this.deserialize(decoder, context, type);
                }

                @Override
                public Optional<V> getDefaultValue(Deserializer.DecoderContext context, Argument<? super Optional<V>> type) {
                    return Optional.empty();
                }
            };
        }
    }

    private static abstract class SpecificOnlyCollectionDeserializer<E, C extends Collection<E>>
    implements CustomizableDeserializer<C> {
        private SpecificOnlyCollectionDeserializer() {
        }

        @Override
        public Deserializer<C> createSpecific(Deserializer.DecoderContext context, Argument<? super C> type) throws SerdeException {
            Object[] generics = type.getTypeParameters();
            if (ArrayUtils.isEmpty(generics)) {
                throw new SerdeException("Cannot deserialize raw list");
            }
            Object collectionItemArgument = generics[0];
            Deserializer valueDeser = context.findDeserializer(collectionItemArgument).createSpecific(context, collectionItemArgument);
            return this.createSpecific((Argument<? super C>)type, (Argument<E>)collectionItemArgument, valueDeser);
        }

        protected abstract Deserializer<C> createSpecific(Argument<? super C> var1, Argument<E> var2, Deserializer<? extends E> var3);
    }

    private static abstract class SpecificOnlyMapDeserializer<K, V, M extends Map<K, V>>
    implements CustomizableDeserializer<M> {
        private SpecificOnlyMapDeserializer() {
        }

        @Override
        public Deserializer<M> createSpecific(Deserializer.DecoderContext context, Argument<? super M> type) throws SerdeException {
            Argument[] generics = type.getTypeParameters();
            if (generics.length == 2) {
                Argument keyType = generics[0];
                Argument valueType = generics[1];
                Deserializer valueDeser = valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : context.findDeserializer(valueType).createSpecific(context, valueType);
                return this.createSpecific(keyType, valueType, valueDeser);
            }
            return new Deserializer<M>(){

                @Override
                public M deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super M> type) throws IOException {
                    Object o = decoder.decodeArbitrary();
                    if (type.isInstance(o)) {
                        return (Map)o;
                    }
                    if (o instanceof Map) {
                        Map map = (Map)this.getDefaultValue(decoderContext, type);
                        map.putAll((Map)o);
                        return map;
                    }
                    throw new SerdeException("Cannot deserialize map of type [" + type + "] from value: " + o);
                }
            };
        }

        @NonNull
        protected abstract Deserializer<M> createSpecific(Argument<K> var1, Argument<V> var2, Deserializer<? extends V> var3);
    }
}

