/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;
import java.util.List;

@Internal
final class SimpleObjectSerializer<T>
implements ObjectSerializer<T> {
    private final List<SerBean.SerProperty<T, Object>> writeProperties;

    SimpleObjectSerializer(SerBean<T> serBean) {
        this.writeProperties = serBean.writeProperties;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try {
            if (value == null) {
                encoder.encodeNull();
            } else {
                Encoder childEncoder = encoder.encodeObject(type);
                for (SerBean.SerProperty<T, Object> property : this.writeProperties) {
                    childEncoder.encodeKey(property.name);
                    Object v = property.get(value);
                    if (v == null) {
                        childEncoder.encodeNull();
                        continue;
                    }
                    property.serializer.serialize(childEncoder, context, property.argument, v);
                }
                childEncoder.finishStructure();
            }
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + type, e);
        }
    }

    @Override
    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        for (SerBean.SerProperty<T, Object> property : this.writeProperties) {
            encoder.encodeKey(property.name);
            Object v = property.get(value);
            if (v == null) {
                encoder.encodeNull();
                continue;
            }
            property.serializer.serialize(encoder, context, property.argument, v);
        }
    }
}

