/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.testcontainers.containers.ParsedDockerComposeFile;
import org.testcontainers.utility.DockerImageName;

public class DockerComposeFiles {
    private final List<ParsedDockerComposeFile> parsedComposeFiles;

    public DockerComposeFiles(List<File> composeFiles) {
        this.parsedComposeFiles = composeFiles.stream().map(ParsedDockerComposeFile::new).collect(Collectors.toList());
    }

    public Set<String> getDependencyImages() {
        Map<String, Set<String>> mergedServiceNameToImageNames = this.mergeServiceDependencyImageNames();
        return this.getImageNames(mergedServiceNameToImageNames);
    }

    private Map<String, Set<String>> mergeServiceDependencyImageNames() {
        HashMap<String, Set<String>> mergedServiceNameToImageNames = new HashMap<String, Set<String>>();
        for (ParsedDockerComposeFile parsedComposeFile : this.parsedComposeFiles) {
            mergedServiceNameToImageNames.putAll(parsedComposeFile.getServiceNameToImageNames());
        }
        return mergedServiceNameToImageNames;
    }

    private Set<String> getImageNames(Map<String, Set<String>> serviceToImageNames) {
        return serviceToImageNames.values().stream().flatMap(Collection::stream).map(DockerImageName::parse).map(DockerImageName::asCanonicalNameString).collect(Collectors.toSet());
    }
}

