/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.crypto.engines;

import org.testcontainers.shaded.org.bouncycastle.crypto.engines.SerpentEngineBase;
import org.testcontainers.shaded.org.bouncycastle.util.Pack;

public final class TnepresEngine
extends SerpentEngineBase {
    @Override
    public String getAlgorithmName() {
        return "Tnepres";
    }

    @Override
    protected int[] makeWorkingKey(byte[] byArray) throws IllegalArgumentException {
        int n;
        int[] nArray = new int[16];
        int n2 = 0;
        int n3 = 0;
        for (n2 = byArray.length - 4; n2 > 0; n2 -= 4) {
            nArray[n3++] = Pack.bigEndianToInt(byArray, n2);
        }
        if (n2 == 0) {
            nArray[n3++] = Pack.bigEndianToInt(byArray, 0);
            if (n3 < 8) {
                nArray[n3] = 1;
            }
        } else {
            throw new IllegalArgumentException("key must be a multiple of 4 bytes");
        }
        int n4 = 132;
        int[] nArray2 = new int[n4];
        for (n = 8; n < 16; ++n) {
            nArray[n] = TnepresEngine.rotateLeft(nArray[n - 8] ^ nArray[n - 5] ^ nArray[n - 3] ^ nArray[n - 1] ^ 0x9E3779B9 ^ n - 8, 11);
        }
        System.arraycopy(nArray, 8, nArray2, 0, 8);
        for (n = 8; n < n4; ++n) {
            nArray2[n] = TnepresEngine.rotateLeft(nArray2[n - 8] ^ nArray2[n - 5] ^ nArray2[n - 3] ^ nArray2[n - 1] ^ 0x9E3779B9 ^ n, 11);
        }
        int[] nArray3 = new int[4];
        this.sb3(nArray3, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        nArray2[0] = nArray3[0];
        nArray2[1] = nArray3[1];
        nArray2[2] = nArray3[2];
        nArray2[3] = nArray3[3];
        this.sb2(nArray3, nArray2[4], nArray2[5], nArray2[6], nArray2[7]);
        nArray2[4] = nArray3[0];
        nArray2[5] = nArray3[1];
        nArray2[6] = nArray3[2];
        nArray2[7] = nArray3[3];
        this.sb1(nArray3, nArray2[8], nArray2[9], nArray2[10], nArray2[11]);
        nArray2[8] = nArray3[0];
        nArray2[9] = nArray3[1];
        nArray2[10] = nArray3[2];
        nArray2[11] = nArray3[3];
        this.sb0(nArray3, nArray2[12], nArray2[13], nArray2[14], nArray2[15]);
        nArray2[12] = nArray3[0];
        nArray2[13] = nArray3[1];
        nArray2[14] = nArray3[2];
        nArray2[15] = nArray3[3];
        this.sb7(nArray3, nArray2[16], nArray2[17], nArray2[18], nArray2[19]);
        nArray2[16] = nArray3[0];
        nArray2[17] = nArray3[1];
        nArray2[18] = nArray3[2];
        nArray2[19] = nArray3[3];
        this.sb6(nArray3, nArray2[20], nArray2[21], nArray2[22], nArray2[23]);
        nArray2[20] = nArray3[0];
        nArray2[21] = nArray3[1];
        nArray2[22] = nArray3[2];
        nArray2[23] = nArray3[3];
        this.sb5(nArray3, nArray2[24], nArray2[25], nArray2[26], nArray2[27]);
        nArray2[24] = nArray3[0];
        nArray2[25] = nArray3[1];
        nArray2[26] = nArray3[2];
        nArray2[27] = nArray3[3];
        this.sb4(nArray3, nArray2[28], nArray2[29], nArray2[30], nArray2[31]);
        nArray2[28] = nArray3[0];
        nArray2[29] = nArray3[1];
        nArray2[30] = nArray3[2];
        nArray2[31] = nArray3[3];
        this.sb3(nArray3, nArray2[32], nArray2[33], nArray2[34], nArray2[35]);
        nArray2[32] = nArray3[0];
        nArray2[33] = nArray3[1];
        nArray2[34] = nArray3[2];
        nArray2[35] = nArray3[3];
        this.sb2(nArray3, nArray2[36], nArray2[37], nArray2[38], nArray2[39]);
        nArray2[36] = nArray3[0];
        nArray2[37] = nArray3[1];
        nArray2[38] = nArray3[2];
        nArray2[39] = nArray3[3];
        this.sb1(nArray3, nArray2[40], nArray2[41], nArray2[42], nArray2[43]);
        nArray2[40] = nArray3[0];
        nArray2[41] = nArray3[1];
        nArray2[42] = nArray3[2];
        nArray2[43] = nArray3[3];
        this.sb0(nArray3, nArray2[44], nArray2[45], nArray2[46], nArray2[47]);
        nArray2[44] = nArray3[0];
        nArray2[45] = nArray3[1];
        nArray2[46] = nArray3[2];
        nArray2[47] = nArray3[3];
        this.sb7(nArray3, nArray2[48], nArray2[49], nArray2[50], nArray2[51]);
        nArray2[48] = nArray3[0];
        nArray2[49] = nArray3[1];
        nArray2[50] = nArray3[2];
        nArray2[51] = nArray3[3];
        this.sb6(nArray3, nArray2[52], nArray2[53], nArray2[54], nArray2[55]);
        nArray2[52] = nArray3[0];
        nArray2[53] = nArray3[1];
        nArray2[54] = nArray3[2];
        nArray2[55] = nArray3[3];
        this.sb5(nArray3, nArray2[56], nArray2[57], nArray2[58], nArray2[59]);
        nArray2[56] = nArray3[0];
        nArray2[57] = nArray3[1];
        nArray2[58] = nArray3[2];
        nArray2[59] = nArray3[3];
        this.sb4(nArray3, nArray2[60], nArray2[61], nArray2[62], nArray2[63]);
        nArray2[60] = nArray3[0];
        nArray2[61] = nArray3[1];
        nArray2[62] = nArray3[2];
        nArray2[63] = nArray3[3];
        this.sb3(nArray3, nArray2[64], nArray2[65], nArray2[66], nArray2[67]);
        nArray2[64] = nArray3[0];
        nArray2[65] = nArray3[1];
        nArray2[66] = nArray3[2];
        nArray2[67] = nArray3[3];
        this.sb2(nArray3, nArray2[68], nArray2[69], nArray2[70], nArray2[71]);
        nArray2[68] = nArray3[0];
        nArray2[69] = nArray3[1];
        nArray2[70] = nArray3[2];
        nArray2[71] = nArray3[3];
        this.sb1(nArray3, nArray2[72], nArray2[73], nArray2[74], nArray2[75]);
        nArray2[72] = nArray3[0];
        nArray2[73] = nArray3[1];
        nArray2[74] = nArray3[2];
        nArray2[75] = nArray3[3];
        this.sb0(nArray3, nArray2[76], nArray2[77], nArray2[78], nArray2[79]);
        nArray2[76] = nArray3[0];
        nArray2[77] = nArray3[1];
        nArray2[78] = nArray3[2];
        nArray2[79] = nArray3[3];
        this.sb7(nArray3, nArray2[80], nArray2[81], nArray2[82], nArray2[83]);
        nArray2[80] = nArray3[0];
        nArray2[81] = nArray3[1];
        nArray2[82] = nArray3[2];
        nArray2[83] = nArray3[3];
        this.sb6(nArray3, nArray2[84], nArray2[85], nArray2[86], nArray2[87]);
        nArray2[84] = nArray3[0];
        nArray2[85] = nArray3[1];
        nArray2[86] = nArray3[2];
        nArray2[87] = nArray3[3];
        this.sb5(nArray3, nArray2[88], nArray2[89], nArray2[90], nArray2[91]);
        nArray2[88] = nArray3[0];
        nArray2[89] = nArray3[1];
        nArray2[90] = nArray3[2];
        nArray2[91] = nArray3[3];
        this.sb4(nArray3, nArray2[92], nArray2[93], nArray2[94], nArray2[95]);
        nArray2[92] = nArray3[0];
        nArray2[93] = nArray3[1];
        nArray2[94] = nArray3[2];
        nArray2[95] = nArray3[3];
        this.sb3(nArray3, nArray2[96], nArray2[97], nArray2[98], nArray2[99]);
        nArray2[96] = nArray3[0];
        nArray2[97] = nArray3[1];
        nArray2[98] = nArray3[2];
        nArray2[99] = nArray3[3];
        this.sb2(nArray3, nArray2[100], nArray2[101], nArray2[102], nArray2[103]);
        nArray2[100] = nArray3[0];
        nArray2[101] = nArray3[1];
        nArray2[102] = nArray3[2];
        nArray2[103] = nArray3[3];
        this.sb1(nArray3, nArray2[104], nArray2[105], nArray2[106], nArray2[107]);
        nArray2[104] = nArray3[0];
        nArray2[105] = nArray3[1];
        nArray2[106] = nArray3[2];
        nArray2[107] = nArray3[3];
        this.sb0(nArray3, nArray2[108], nArray2[109], nArray2[110], nArray2[111]);
        nArray2[108] = nArray3[0];
        nArray2[109] = nArray3[1];
        nArray2[110] = nArray3[2];
        nArray2[111] = nArray3[3];
        this.sb7(nArray3, nArray2[112], nArray2[113], nArray2[114], nArray2[115]);
        nArray2[112] = nArray3[0];
        nArray2[113] = nArray3[1];
        nArray2[114] = nArray3[2];
        nArray2[115] = nArray3[3];
        this.sb6(nArray3, nArray2[116], nArray2[117], nArray2[118], nArray2[119]);
        nArray2[116] = nArray3[0];
        nArray2[117] = nArray3[1];
        nArray2[118] = nArray3[2];
        nArray2[119] = nArray3[3];
        this.sb5(nArray3, nArray2[120], nArray2[121], nArray2[122], nArray2[123]);
        nArray2[120] = nArray3[0];
        nArray2[121] = nArray3[1];
        nArray2[122] = nArray3[2];
        nArray2[123] = nArray3[3];
        this.sb4(nArray3, nArray2[124], nArray2[125], nArray2[126], nArray2[127]);
        nArray2[124] = nArray3[0];
        nArray2[125] = nArray3[1];
        nArray2[126] = nArray3[2];
        nArray2[127] = nArray3[3];
        this.sb3(nArray3, nArray2[128], nArray2[129], nArray2[130], nArray2[131]);
        nArray2[128] = nArray3[0];
        nArray2[129] = nArray3[1];
        nArray2[130] = nArray3[2];
        nArray2[131] = nArray3[3];
        return nArray2;
    }

    @Override
    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[4];
        nArray[3] = Pack.bigEndianToInt(byArray, n);
        nArray[2] = Pack.bigEndianToInt(byArray, n + 4);
        nArray[1] = Pack.bigEndianToInt(byArray, n + 8);
        nArray[0] = Pack.bigEndianToInt(byArray, n + 12);
        this.sb0(nArray, this.wKey[0] ^ nArray[0], this.wKey[1] ^ nArray[1], this.wKey[2] ^ nArray[2], this.wKey[3] ^ nArray[3]);
        this.LT(nArray);
        this.sb1(nArray, this.wKey[4] ^ nArray[0], this.wKey[5] ^ nArray[1], this.wKey[6] ^ nArray[2], this.wKey[7] ^ nArray[3]);
        this.LT(nArray);
        this.sb2(nArray, this.wKey[8] ^ nArray[0], this.wKey[9] ^ nArray[1], this.wKey[10] ^ nArray[2], this.wKey[11] ^ nArray[3]);
        this.LT(nArray);
        this.sb3(nArray, this.wKey[12] ^ nArray[0], this.wKey[13] ^ nArray[1], this.wKey[14] ^ nArray[2], this.wKey[15] ^ nArray[3]);
        this.LT(nArray);
        this.sb4(nArray, this.wKey[16] ^ nArray[0], this.wKey[17] ^ nArray[1], this.wKey[18] ^ nArray[2], this.wKey[19] ^ nArray[3]);
        this.LT(nArray);
        this.sb5(nArray, this.wKey[20] ^ nArray[0], this.wKey[21] ^ nArray[1], this.wKey[22] ^ nArray[2], this.wKey[23] ^ nArray[3]);
        this.LT(nArray);
        this.sb6(nArray, this.wKey[24] ^ nArray[0], this.wKey[25] ^ nArray[1], this.wKey[26] ^ nArray[2], this.wKey[27] ^ nArray[3]);
        this.LT(nArray);
        this.sb7(nArray, this.wKey[28] ^ nArray[0], this.wKey[29] ^ nArray[1], this.wKey[30] ^ nArray[2], this.wKey[31] ^ nArray[3]);
        this.LT(nArray);
        this.sb0(nArray, this.wKey[32] ^ nArray[0], this.wKey[33] ^ nArray[1], this.wKey[34] ^ nArray[2], this.wKey[35] ^ nArray[3]);
        this.LT(nArray);
        this.sb1(nArray, this.wKey[36] ^ nArray[0], this.wKey[37] ^ nArray[1], this.wKey[38] ^ nArray[2], this.wKey[39] ^ nArray[3]);
        this.LT(nArray);
        this.sb2(nArray, this.wKey[40] ^ nArray[0], this.wKey[41] ^ nArray[1], this.wKey[42] ^ nArray[2], this.wKey[43] ^ nArray[3]);
        this.LT(nArray);
        this.sb3(nArray, this.wKey[44] ^ nArray[0], this.wKey[45] ^ nArray[1], this.wKey[46] ^ nArray[2], this.wKey[47] ^ nArray[3]);
        this.LT(nArray);
        this.sb4(nArray, this.wKey[48] ^ nArray[0], this.wKey[49] ^ nArray[1], this.wKey[50] ^ nArray[2], this.wKey[51] ^ nArray[3]);
        this.LT(nArray);
        this.sb5(nArray, this.wKey[52] ^ nArray[0], this.wKey[53] ^ nArray[1], this.wKey[54] ^ nArray[2], this.wKey[55] ^ nArray[3]);
        this.LT(nArray);
        this.sb6(nArray, this.wKey[56] ^ nArray[0], this.wKey[57] ^ nArray[1], this.wKey[58] ^ nArray[2], this.wKey[59] ^ nArray[3]);
        this.LT(nArray);
        this.sb7(nArray, this.wKey[60] ^ nArray[0], this.wKey[61] ^ nArray[1], this.wKey[62] ^ nArray[2], this.wKey[63] ^ nArray[3]);
        this.LT(nArray);
        this.sb0(nArray, this.wKey[64] ^ nArray[0], this.wKey[65] ^ nArray[1], this.wKey[66] ^ nArray[2], this.wKey[67] ^ nArray[3]);
        this.LT(nArray);
        this.sb1(nArray, this.wKey[68] ^ nArray[0], this.wKey[69] ^ nArray[1], this.wKey[70] ^ nArray[2], this.wKey[71] ^ nArray[3]);
        this.LT(nArray);
        this.sb2(nArray, this.wKey[72] ^ nArray[0], this.wKey[73] ^ nArray[1], this.wKey[74] ^ nArray[2], this.wKey[75] ^ nArray[3]);
        this.LT(nArray);
        this.sb3(nArray, this.wKey[76] ^ nArray[0], this.wKey[77] ^ nArray[1], this.wKey[78] ^ nArray[2], this.wKey[79] ^ nArray[3]);
        this.LT(nArray);
        this.sb4(nArray, this.wKey[80] ^ nArray[0], this.wKey[81] ^ nArray[1], this.wKey[82] ^ nArray[2], this.wKey[83] ^ nArray[3]);
        this.LT(nArray);
        this.sb5(nArray, this.wKey[84] ^ nArray[0], this.wKey[85] ^ nArray[1], this.wKey[86] ^ nArray[2], this.wKey[87] ^ nArray[3]);
        this.LT(nArray);
        this.sb6(nArray, this.wKey[88] ^ nArray[0], this.wKey[89] ^ nArray[1], this.wKey[90] ^ nArray[2], this.wKey[91] ^ nArray[3]);
        this.LT(nArray);
        this.sb7(nArray, this.wKey[92] ^ nArray[0], this.wKey[93] ^ nArray[1], this.wKey[94] ^ nArray[2], this.wKey[95] ^ nArray[3]);
        this.LT(nArray);
        this.sb0(nArray, this.wKey[96] ^ nArray[0], this.wKey[97] ^ nArray[1], this.wKey[98] ^ nArray[2], this.wKey[99] ^ nArray[3]);
        this.LT(nArray);
        this.sb1(nArray, this.wKey[100] ^ nArray[0], this.wKey[101] ^ nArray[1], this.wKey[102] ^ nArray[2], this.wKey[103] ^ nArray[3]);
        this.LT(nArray);
        this.sb2(nArray, this.wKey[104] ^ nArray[0], this.wKey[105] ^ nArray[1], this.wKey[106] ^ nArray[2], this.wKey[107] ^ nArray[3]);
        this.LT(nArray);
        this.sb3(nArray, this.wKey[108] ^ nArray[0], this.wKey[109] ^ nArray[1], this.wKey[110] ^ nArray[2], this.wKey[111] ^ nArray[3]);
        this.LT(nArray);
        this.sb4(nArray, this.wKey[112] ^ nArray[0], this.wKey[113] ^ nArray[1], this.wKey[114] ^ nArray[2], this.wKey[115] ^ nArray[3]);
        this.LT(nArray);
        this.sb5(nArray, this.wKey[116] ^ nArray[0], this.wKey[117] ^ nArray[1], this.wKey[118] ^ nArray[2], this.wKey[119] ^ nArray[3]);
        this.LT(nArray);
        this.sb6(nArray, this.wKey[120] ^ nArray[0], this.wKey[121] ^ nArray[1], this.wKey[122] ^ nArray[2], this.wKey[123] ^ nArray[3]);
        this.LT(nArray);
        this.sb7(nArray, this.wKey[124] ^ nArray[0], this.wKey[125] ^ nArray[1], this.wKey[126] ^ nArray[2], this.wKey[127] ^ nArray[3]);
        Pack.intToBigEndian(this.wKey[131] ^ nArray[3], byArray2, n2);
        Pack.intToBigEndian(this.wKey[130] ^ nArray[2], byArray2, n2 + 4);
        Pack.intToBigEndian(this.wKey[129] ^ nArray[1], byArray2, n2 + 8);
        Pack.intToBigEndian(this.wKey[128] ^ nArray[0], byArray2, n2 + 12);
    }

    @Override
    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[4];
        nArray[3] = this.wKey[131] ^ Pack.bigEndianToInt(byArray, n);
        nArray[2] = this.wKey[130] ^ Pack.bigEndianToInt(byArray, n + 4);
        nArray[1] = this.wKey[129] ^ Pack.bigEndianToInt(byArray, n + 8);
        nArray[0] = this.wKey[128] ^ Pack.bigEndianToInt(byArray, n + 12);
        this.ib7(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[124];
        nArray[1] = nArray[1] ^ this.wKey[125];
        nArray[2] = nArray[2] ^ this.wKey[126];
        nArray[3] = nArray[3] ^ this.wKey[127];
        this.inverseLT(nArray);
        this.ib6(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[120];
        nArray[1] = nArray[1] ^ this.wKey[121];
        nArray[2] = nArray[2] ^ this.wKey[122];
        nArray[3] = nArray[3] ^ this.wKey[123];
        this.inverseLT(nArray);
        this.ib5(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[116];
        nArray[1] = nArray[1] ^ this.wKey[117];
        nArray[2] = nArray[2] ^ this.wKey[118];
        nArray[3] = nArray[3] ^ this.wKey[119];
        this.inverseLT(nArray);
        this.ib4(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[112];
        nArray[1] = nArray[1] ^ this.wKey[113];
        nArray[2] = nArray[2] ^ this.wKey[114];
        nArray[3] = nArray[3] ^ this.wKey[115];
        this.inverseLT(nArray);
        this.ib3(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[108];
        nArray[1] = nArray[1] ^ this.wKey[109];
        nArray[2] = nArray[2] ^ this.wKey[110];
        nArray[3] = nArray[3] ^ this.wKey[111];
        this.inverseLT(nArray);
        this.ib2(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[104];
        nArray[1] = nArray[1] ^ this.wKey[105];
        nArray[2] = nArray[2] ^ this.wKey[106];
        nArray[3] = nArray[3] ^ this.wKey[107];
        this.inverseLT(nArray);
        this.ib1(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[100];
        nArray[1] = nArray[1] ^ this.wKey[101];
        nArray[2] = nArray[2] ^ this.wKey[102];
        nArray[3] = nArray[3] ^ this.wKey[103];
        this.inverseLT(nArray);
        this.ib0(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[96];
        nArray[1] = nArray[1] ^ this.wKey[97];
        nArray[2] = nArray[2] ^ this.wKey[98];
        nArray[3] = nArray[3] ^ this.wKey[99];
        this.inverseLT(nArray);
        this.ib7(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[92];
        nArray[1] = nArray[1] ^ this.wKey[93];
        nArray[2] = nArray[2] ^ this.wKey[94];
        nArray[3] = nArray[3] ^ this.wKey[95];
        this.inverseLT(nArray);
        this.ib6(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[88];
        nArray[1] = nArray[1] ^ this.wKey[89];
        nArray[2] = nArray[2] ^ this.wKey[90];
        nArray[3] = nArray[3] ^ this.wKey[91];
        this.inverseLT(nArray);
        this.ib5(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[84];
        nArray[1] = nArray[1] ^ this.wKey[85];
        nArray[2] = nArray[2] ^ this.wKey[86];
        nArray[3] = nArray[3] ^ this.wKey[87];
        this.inverseLT(nArray);
        this.ib4(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[80];
        nArray[1] = nArray[1] ^ this.wKey[81];
        nArray[2] = nArray[2] ^ this.wKey[82];
        nArray[3] = nArray[3] ^ this.wKey[83];
        this.inverseLT(nArray);
        this.ib3(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[76];
        nArray[1] = nArray[1] ^ this.wKey[77];
        nArray[2] = nArray[2] ^ this.wKey[78];
        nArray[3] = nArray[3] ^ this.wKey[79];
        this.inverseLT(nArray);
        this.ib2(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[72];
        nArray[1] = nArray[1] ^ this.wKey[73];
        nArray[2] = nArray[2] ^ this.wKey[74];
        nArray[3] = nArray[3] ^ this.wKey[75];
        this.inverseLT(nArray);
        this.ib1(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[68];
        nArray[1] = nArray[1] ^ this.wKey[69];
        nArray[2] = nArray[2] ^ this.wKey[70];
        nArray[3] = nArray[3] ^ this.wKey[71];
        this.inverseLT(nArray);
        this.ib0(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[64];
        nArray[1] = nArray[1] ^ this.wKey[65];
        nArray[2] = nArray[2] ^ this.wKey[66];
        nArray[3] = nArray[3] ^ this.wKey[67];
        this.inverseLT(nArray);
        this.ib7(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[60];
        nArray[1] = nArray[1] ^ this.wKey[61];
        nArray[2] = nArray[2] ^ this.wKey[62];
        nArray[3] = nArray[3] ^ this.wKey[63];
        this.inverseLT(nArray);
        this.ib6(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[56];
        nArray[1] = nArray[1] ^ this.wKey[57];
        nArray[2] = nArray[2] ^ this.wKey[58];
        nArray[3] = nArray[3] ^ this.wKey[59];
        this.inverseLT(nArray);
        this.ib5(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[52];
        nArray[1] = nArray[1] ^ this.wKey[53];
        nArray[2] = nArray[2] ^ this.wKey[54];
        nArray[3] = nArray[3] ^ this.wKey[55];
        this.inverseLT(nArray);
        this.ib4(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[48];
        nArray[1] = nArray[1] ^ this.wKey[49];
        nArray[2] = nArray[2] ^ this.wKey[50];
        nArray[3] = nArray[3] ^ this.wKey[51];
        this.inverseLT(nArray);
        this.ib3(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[44];
        nArray[1] = nArray[1] ^ this.wKey[45];
        nArray[2] = nArray[2] ^ this.wKey[46];
        nArray[3] = nArray[3] ^ this.wKey[47];
        this.inverseLT(nArray);
        this.ib2(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[40];
        nArray[1] = nArray[1] ^ this.wKey[41];
        nArray[2] = nArray[2] ^ this.wKey[42];
        nArray[3] = nArray[3] ^ this.wKey[43];
        this.inverseLT(nArray);
        this.ib1(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[36];
        nArray[1] = nArray[1] ^ this.wKey[37];
        nArray[2] = nArray[2] ^ this.wKey[38];
        nArray[3] = nArray[3] ^ this.wKey[39];
        this.inverseLT(nArray);
        this.ib0(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[32];
        nArray[1] = nArray[1] ^ this.wKey[33];
        nArray[2] = nArray[2] ^ this.wKey[34];
        nArray[3] = nArray[3] ^ this.wKey[35];
        this.inverseLT(nArray);
        this.ib7(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[28];
        nArray[1] = nArray[1] ^ this.wKey[29];
        nArray[2] = nArray[2] ^ this.wKey[30];
        nArray[3] = nArray[3] ^ this.wKey[31];
        this.inverseLT(nArray);
        this.ib6(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[24];
        nArray[1] = nArray[1] ^ this.wKey[25];
        nArray[2] = nArray[2] ^ this.wKey[26];
        nArray[3] = nArray[3] ^ this.wKey[27];
        this.inverseLT(nArray);
        this.ib5(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[20];
        nArray[1] = nArray[1] ^ this.wKey[21];
        nArray[2] = nArray[2] ^ this.wKey[22];
        nArray[3] = nArray[3] ^ this.wKey[23];
        this.inverseLT(nArray);
        this.ib4(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[16];
        nArray[1] = nArray[1] ^ this.wKey[17];
        nArray[2] = nArray[2] ^ this.wKey[18];
        nArray[3] = nArray[3] ^ this.wKey[19];
        this.inverseLT(nArray);
        this.ib3(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[12];
        nArray[1] = nArray[1] ^ this.wKey[13];
        nArray[2] = nArray[2] ^ this.wKey[14];
        nArray[3] = nArray[3] ^ this.wKey[15];
        this.inverseLT(nArray);
        this.ib2(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[8];
        nArray[1] = nArray[1] ^ this.wKey[9];
        nArray[2] = nArray[2] ^ this.wKey[10];
        nArray[3] = nArray[3] ^ this.wKey[11];
        this.inverseLT(nArray);
        this.ib1(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        nArray[0] = nArray[0] ^ this.wKey[4];
        nArray[1] = nArray[1] ^ this.wKey[5];
        nArray[2] = nArray[2] ^ this.wKey[6];
        nArray[3] = nArray[3] ^ this.wKey[7];
        this.inverseLT(nArray);
        this.ib0(nArray, nArray[0], nArray[1], nArray[2], nArray[3]);
        Pack.intToBigEndian(nArray[3] ^ this.wKey[3], byArray2, n2);
        Pack.intToBigEndian(nArray[2] ^ this.wKey[2], byArray2, n2 + 4);
        Pack.intToBigEndian(nArray[1] ^ this.wKey[1], byArray2, n2 + 8);
        Pack.intToBigEndian(nArray[0] ^ this.wKey[0], byArray2, n2 + 12);
    }
}

