/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.InternalHttpFilter;
import java.util.concurrent.Executor;
import java.util.function.Function;

@Internal
record AsyncFilter(InternalHttpFilter actual, Executor executor) implements InternalHttpFilter
{
    @Override
    public boolean isFiltersRequest() {
        return this.actual.isFiltersRequest();
    }

    @Override
    public boolean isFiltersResponse() {
        return this.actual.isFiltersResponse();
    }

    @Override
    public ExecutionFlow<FilterContext> processRequestFilter(FilterContext context, Function<FilterContext, ExecutionFlow<FilterContext>> downstream) {
        if (this.isFiltersRequest()) {
            return ExecutionFlow.async(this.executor, () -> this.actual.processRequestFilter(context, downstream));
        }
        return InternalHttpFilter.super.processRequestFilter(context, downstream);
    }

    @Override
    public ExecutionFlow<FilterContext> processResponseFilter(FilterContext context, Throwable exceptionToFilter) {
        if (this.isFiltersResponse()) {
            return ExecutionFlow.async(this.executor, () -> this.actual.processResponseFilter(context, exceptionToFilter));
        }
        return InternalHttpFilter.super.processResponseFilter(context, exceptionToFilter);
    }

    @Override
    public int getOrder() {
        return this.actual.getOrder();
    }
}

