/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.hateoas.Resource;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.json.JsonConfiguration;
import jakarta.inject.Singleton;
import java.util.ArrayList;

@Singleton
@Secondary
public class HateoasErrorResponseProcessor
implements ErrorResponseProcessor<JsonError> {
    private final boolean alwaysSerializeErrorsAsList;

    public HateoasErrorResponseProcessor(JsonConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    @Override
    @NonNull
    public MutableHttpResponse<JsonError> processResponse(@NonNull ErrorContext errorContext, @NonNull MutableHttpResponse<?> response) {
        JsonError error;
        if (errorContext.getRequest().getMethod() == HttpMethod.HEAD) {
            return response;
        }
        if (!errorContext.hasErrors()) {
            error = new JsonError(response.reason());
        } else if (errorContext.getErrors().size() == 1 && !this.alwaysSerializeErrorsAsList) {
            Error jsonError = errorContext.getErrors().get(0);
            error = new JsonError(jsonError.getMessage());
            jsonError.getPath().ifPresent(error::path);
        } else {
            error = new JsonError(response.reason());
            ArrayList<Resource> errors = new ArrayList<Resource>();
            for (Error jsonError : errorContext.getErrors()) {
                errors.add(new JsonError(jsonError.getMessage()).path(jsonError.getPath().orElse(null)));
            }
            error.embedded((CharSequence)"errors", errors);
        }
        error.link(Link.SELF, Link.of(errorContext.getRequest().getUri()));
        return response.body(error).contentType(MediaType.APPLICATION_JSON_TYPE);
    }
}

