/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.annotation.Any;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.AnnotationMetadataQualifier;
import io.micronaut.inject.qualifiers.AnnotationQualifier;
import io.micronaut.inject.qualifiers.AnnotationStereotypeQualifier;
import io.micronaut.inject.qualifiers.NamedAnnotationStereotypeQualifier;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
final class QualifierUtils {
    private QualifierUtils() {
    }

    static <T> boolean matchType(Class<T> beanType, BeanType<T> candidate) {
        return candidate.isContainerType() || beanType.isAssignableFrom(beanType);
    }

    static <T> boolean matchAny(Class<T> beanType, BeanType<T> candidate) {
        return beanType != Object.class && candidate.getAnnotationMetadata().hasDeclaredAnnotation(Any.class);
    }

    static <T> boolean matchByCandidateName(BeanType<T> candidate, Class<T> beanType, String value) {
        String definedCandidateName;
        if (candidate instanceof NameResolver) {
            NameResolver resolver = (NameResolver)((Object)candidate);
            Optional<String> resolvedName = resolver.resolveName();
            definedCandidateName = resolvedName.orElse(candidate.getBeanType().getSimpleName());
        } else {
            definedCandidateName = candidate.getBeanType().getSimpleName();
        }
        return definedCandidateName.equalsIgnoreCase(value) || definedCandidateName.equalsIgnoreCase(value + beanType.getSimpleName());
    }

    public static boolean annotationQualifiersEquals(@NonNull Object o1, @NonNull Object o2) {
        Map.Entry<String, Map<CharSequence, Object>> val1 = QualifierUtils.extractAnnotationAndBindingValues(o1);
        if (val1 == null) {
            return false;
        }
        Map.Entry<String, Map<CharSequence, Object>> val2 = QualifierUtils.extractAnnotationAndBindingValues(o2);
        if (val2 == null) {
            return false;
        }
        return Objects.equals(val1.getKey(), val2.getKey()) && Objects.equals(val1.getValue(), val2.getValue());
    }

    @Nullable
    private static Map.Entry<String, Map<CharSequence, Object>> extractAnnotationAndBindingValues(@NonNull Object o) {
        if (o instanceof NamedAnnotationStereotypeQualifier) {
            NamedAnnotationStereotypeQualifier that = (NamedAnnotationStereotypeQualifier)o;
            return new AbstractMap.SimpleEntry<String, Object>(that.stereotype, null);
        }
        if (o instanceof AnnotationStereotypeQualifier) {
            AnnotationStereotypeQualifier that = (AnnotationStereotypeQualifier)o;
            return new AbstractMap.SimpleEntry<String, Object>(that.stereotype.getName(), null);
        }
        if (o instanceof AnnotationMetadataQualifier) {
            AnnotationMetadataQualifier that = (AnnotationMetadataQualifier)o;
            if (that.qualifierAnn == null) {
                return new AbstractMap.SimpleEntry<String, Object>(that.annotationName, null);
            }
            return new AbstractMap.SimpleEntry<String, Map<CharSequence, Object>>(that.annotationName, that.qualifierAnn.getValues());
        }
        if (o instanceof AnnotationQualifier) {
            AnnotationQualifier that = (AnnotationQualifier)o;
            return new AbstractMap.SimpleEntry<String, Object>(that.annotation.annotationType().getName(), null);
        }
        return null;
    }
}

