/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import java.util.Objects;

@Internal
final class DeserBeanKey {
    private final Argument<?> type;
    @Nullable
    private final SerdeArgumentConf serdeArgumentConf;
    private final int hashCode;

    public DeserBeanKey(@NonNull Argument<?> type, @Nullable SerdeArgumentConf serdeArgumentConf) {
        this.type = type;
        this.serdeArgumentConf = serdeArgumentConf;
        this.hashCode = type.typeHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeserBeanKey that = (DeserBeanKey)o;
        return this.type.equalsType(that.type) && Objects.equals(this.serdeArgumentConf, that.serdeArgumentConf);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NonNull
    public Argument<?> getType() {
        return this.type;
    }
}

