/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

@Internal
public final class EnvironmentProperties {
    private static final char[] DOT_DASH = new char[]{'.', '-'};
    private final EnvironmentProperties delegate;
    private final Map<String, List<String>> cache = new HashMap<String, List<String>>();

    private EnvironmentProperties(EnvironmentProperties delegate) {
        this.delegate = delegate;
    }

    public static EnvironmentProperties of(@NonNull Map<String, List<String>> preComputed) {
        EnvironmentProperties current = new EnvironmentProperties(null);
        current.cache.putAll(preComputed);
        return current;
    }

    @NonNull
    public Map<String, List<String>> asMap() {
        return Collections.unmodifiableMap(this.cache);
    }

    public static EnvironmentProperties fork(EnvironmentProperties delegate) {
        return new EnvironmentProperties(delegate);
    }

    public static EnvironmentProperties empty() {
        return new EnvironmentProperties(null);
    }

    public List<String> findPropertyNamesForEnvironmentVariable(String env) {
        List<String> result;
        if (this.delegate != null && (result = this.delegate.cache.get(env)) != null) {
            return result;
        }
        return this.cache.computeIfAbsent(env, new Function<String, List<String>>(){

            @Override
            public List<String> apply(String env1) {
                return EnvironmentProperties.computePropertiesFor(env1);
            }
        });
    }

    private static List<String> computePropertiesFor(String env) {
        env = env.toLowerCase(Locale.ENGLISH);
        ArrayList<Integer> separatorIndexList = new ArrayList<Integer>();
        char[] propertyArr = env.toCharArray();
        for (int i = 0; i < propertyArr.length; ++i) {
            if (propertyArr[i] != '_') continue;
            separatorIndexList.add(i);
        }
        if (!separatorIndexList.isEmpty()) {
            int[] separatorIndexes = separatorIndexList.stream().mapToInt(Integer::intValue).toArray();
            int separatorCount = separatorIndexes.length;
            int[] halves = new int[separatorCount];
            byte[] separator = new byte[separatorCount];
            int permutations = (int)Math.pow(2.0, separatorCount);
            for (int i = 0; i < halves.length; ++i) {
                int start = i == 0 ? permutations : halves[i - 1];
                halves[i] = start / 2;
            }
            String[] properties = new String[permutations];
            for (int i = 0; i < permutations; ++i) {
                int round = i + 1;
                for (int s2 = 0; s2 < separatorCount; ++s2) {
                    propertyArr[separatorIndexes[s2]] = DOT_DASH[separator[s2]];
                    if (round % halves[s2] != 0) continue;
                    int n = s2;
                    separator[n] = (byte)(separator[n] ^ 1);
                }
                properties[i] = new String(propertyArr);
            }
            return Arrays.asList(properties);
        }
        return Collections.singletonList(env);
    }
}

