/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.RawMessageBodyHandler;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@BootstrapContextCompatible
@Bean(typed={RawMessageBodyHandler.class})
public final class WritableBodyWriter
implements RawMessageBodyHandler<Writable> {
    private final ApplicationConfiguration applicationConfiguration;

    public WritableBodyWriter(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public Collection<? extends Class<?>> getTypes() {
        return Set.of(Writable.class);
    }

    @Override
    public void writeTo(Argument<Writable> type, MediaType mediaType, Writable object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        if (mediaType != null && !outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.set("Content-Type", mediaType);
        }
        try {
            object.writeTo(outputStream, MessageBodyWriter.getCharset(outgoingHeaders));
            outputStream.flush();
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }

    private Writable read0(ByteBuffer<?> byteBuffer) {
        String s2 = byteBuffer.toString(this.applicationConfiguration.getDefaultCharset());
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)((Object)byteBuffer);
            rc.release();
        }
        return w -> w.write(s2);
    }

    @Override
    public Publisher<? extends Writable> readChunked(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, Publisher<ByteBuffer<?>> input) {
        return Flux.from(input).map(this::read0);
    }

    @Override
    public Writable read(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return this.read0(byteBuffer);
    }

    @Override
    public Writable read(Argument<Writable> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        String s2;
        try {
            s2 = new String(inputStream.readAllBytes(), this.applicationConfiguration.getDefaultCharset());
        }
        catch (IOException e) {
            throw new CodecException("Failed to read InputStream", e);
        }
        return w -> w.write(s2);
    }
}

