/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;

final class ExactTypeArgumentNameQualifier<T>
extends FilteringQualifier<T> {
    private static final Logger LOG = ClassUtils.getLogger(TypeArgumentQualifier.class);
    private final String typeName;

    ExactTypeArgumentNameQualifier(String typeName) {
        this.typeName = Objects.requireNonNull(typeName, "Type name cannot be null");
    }

    @Override
    public boolean doesQualify(Class<T> beanType, BeanType<T> candidate) {
        if (!beanType.isAssignableFrom(candidate.getBeanType())) {
            return false;
        }
        List<Class<?>> typeArguments = this.getTypeArguments(beanType, candidate);
        boolean result = this.areTypesCompatible(typeArguments);
        if (LOG.isTraceEnabled() && !result) {
            LOG.trace("Bean type {} is not compatible with candidate generic types [{}] of candidate {}", beanType, CollectionUtils.toString(typeArguments), candidate);
        }
        return result;
    }

    private boolean areTypesCompatible(List<Class<?>> typeArguments) {
        if (typeArguments.isEmpty()) {
            return true;
        }
        if (typeArguments.size() == 1) {
            for (Class<?> typeArgument : typeArguments) {
                if (!this.typeName.equals(typeArgument.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }

    private <BT extends BeanType<T>> List<Class<?>> getTypeArguments(Class<T> beanType, BT candidate) {
        if (candidate instanceof BeanDefinition) {
            BeanDefinition definition = (BeanDefinition)candidate;
            return definition.getTypeArguments(beanType).stream().map(TypeInformation::getType).collect(Collectors.toList());
        }
        if (beanType.isInterface()) {
            return Arrays.asList(GenericTypeUtils.resolveInterfaceTypeArguments(candidate.getBeanType(), beanType));
        }
        return Arrays.asList(GenericTypeUtils.resolveSuperTypeGenericArguments(candidate.getBeanType(), beanType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExactTypeArgumentNameQualifier that = (ExactTypeArgumentNameQualifier)o;
        return this.generify(this.typeName).equals(this.generify(that.typeName));
    }

    private String generify(String typeName) {
        return "<" + typeName + ">";
    }

    public int hashCode() {
        return this.generify(this.typeName).hashCode();
    }

    public String toString() {
        return this.generify(this.typeName);
    }
}

