/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.logging;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.logging.LogLevel;
import io.micronaut.logging.LoggingSystem;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BootstrapContextCompatible
@Singleton
@Context
@Requirements(value={@Requires(beans={LoggingSystem.class}), @Requires(beans={Environment.class}), @Requires(property="logger")})
@Internal
final class PropertiesLoggingLevelsConfigurer
implements ApplicationEventListener<RefreshEvent> {
    static final String LOGGER_PROPERTY_PREFIX = "logger";
    static final String LOGGER_LEVELS_PROPERTY_PREFIX = "logger.levels";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesLoggingLevelsConfigurer.class);
    private final Environment environment;
    private final List<LoggingSystem> loggingSystems;

    public PropertiesLoggingLevelsConfigurer(Environment environment, List<LoggingSystem> loggingSystems) {
        this.environment = environment;
        this.loggingSystems = loggingSystems;
        this.initLogging();
        this.configureLogLevels();
    }

    @Override
    public void onApplicationEvent(RefreshEvent event) {
        this.initLogging();
        this.configureLogLevels();
    }

    private void initLogging() {
        this.loggingSystems.forEach(LoggingSystem::refresh);
    }

    private void configureLogLevels() {
        Map<String, Object> rawProperties = this.environment.getProperties(LOGGER_LEVELS_PROPERTY_PREFIX, StringConvention.RAW);
        Map<String, Object> generatedProperties = this.environment.getProperties(LOGGER_LEVELS_PROPERTY_PREFIX);
        HashMap<String, Object> properties = new HashMap<String, Object>(generatedProperties.size() + rawProperties.size(), 1.0f);
        properties.putAll(rawProperties);
        properties.putAll(generatedProperties);
        properties.forEach(this::configureLogLevelForPrefix);
    }

    private void configureLogLevelForPrefix(String loggerPrefix, Object levelValue) {
        Boolean boolean1;
        LogLevel newLevel = levelValue instanceof Boolean && (boolean1 = (Boolean)levelValue) == false ? LogLevel.OFF : PropertiesLoggingLevelsConfigurer.toLogLevel(levelValue.toString());
        if (newLevel == null) {
            throw new ConfigurationException("Invalid log level: '" + levelValue + "' for logger: '" + loggerPrefix + "'");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting log level '{}' for logger: '{}'", (Object)newLevel, (Object)loggerPrefix);
        }
        LOGGER.info("Setting log level '{}' for logger: '{}'", (Object)newLevel, (Object)loggerPrefix);
        for (LoggingSystem loggingSystem : this.loggingSystems) {
            loggingSystem.setLogLevel(loggerPrefix, newLevel);
        }
    }

    private static LogLevel toLogLevel(String logLevel) {
        if (StringUtils.isEmpty(logLevel)) {
            return LogLevel.NOT_SPECIFIED;
        }
        try {
            return Enum.valueOf(LogLevel.class, logLevel);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

