/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;
import java.util.Collection;

final class CustomizedIterableSerializer<T>
implements Serializer<Iterable<T>> {
    private final Argument<T> generic;
    private final Serializer<? super T> componentSerializer;

    CustomizedIterableSerializer(Argument<T> generic2, Serializer<? super T> componentSerializer) {
        this.generic = generic2;
        this.componentSerializer = componentSerializer;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Iterable<T>> type, Iterable<T> value) throws IOException {
        try (Encoder array = encoder.encodeArray(type);){
            for (T t2 : value) {
                if (t2 == null) {
                    encoder.encodeNull();
                    continue;
                }
                this.componentSerializer.serialize(array, context, this.generic, t2);
            }
        }
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, Iterable<T> value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return !value.iterator().hasNext();
    }

    @Override
    public boolean isAbsent(Serializer.EncoderContext context, Iterable<T> value) {
        return value == null;
    }
}

