/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import java.util.Optional;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.utility.TestcontainersConfiguration;

@Deprecated
public final class EnvironmentAndSystemPropertyClientProviderStrategy
extends DockerClientProviderStrategy {
    public static final int PRIORITY = 100;
    private final DockerClientConfig dockerClientConfig;
    private final boolean applicable;

    public EnvironmentAndSystemPropertyClientProviderStrategy() {
        this(DefaultDockerClientConfig.createDefaultConfigBuilder());
    }

    EnvironmentAndSystemPropertyClientProviderStrategy(DefaultDockerClientConfig.Builder configBuilder) {
        String dockerConfigSource;
        switch (dockerConfigSource = TestcontainersConfiguration.getInstance().getEnvVarOrProperty("dockerconfig.source", "auto")) {
            case "auto": {
                Optional<String> dockerHost = this.getSetting("docker.host");
                dockerHost.ifPresent(configBuilder::withDockerHost);
                this.applicable = dockerHost.isPresent();
                this.getSetting("docker.tls.verify").ifPresent(configBuilder::withDockerTlsVerify);
                this.getSetting("docker.cert.path").ifPresent(configBuilder::withDockerCertPath);
                break;
            }
            case "autoIgnoringUserProperties": {
                this.applicable = configBuilder.isDockerHostSetExplicitly();
                break;
            }
            default: {
                throw new InvalidConfigurationException("Invalid value for dockerconfig.source: " + dockerConfigSource);
            }
        }
        this.dockerClientConfig = configBuilder.build();
    }

    private Optional<String> getSetting(String name) {
        return Optional.ofNullable(TestcontainersConfiguration.getInstance().getEnvVarOrUserProperty(name, null));
    }

    @Override
    public TransportConfig getTransportConfig() {
        return TransportConfig.builder().dockerHost(this.dockerClientConfig.getDockerHost()).sslConfig(this.dockerClientConfig.getSSLConfig()).build();
    }

    @Override
    protected int getPriority() {
        return 100;
    }

    @Override
    public String getDescription() {
        return "Environment variables, system properties and defaults. Resolved dockerHost=" + this.dockerClientConfig.getDockerHost();
    }

    @Override
    protected boolean isPersistable() {
        return false;
    }

    @Override
    public boolean isApplicable() {
        return this.applicable;
    }
}

