/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultRuntimeBeanDefinition;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanContextConditional;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.InstantiatableBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface RuntimeBeanDefinition<T>
extends BeanDefinitionReference<T>,
InstantiatableBeanDefinition<T>,
BeanContextConditional {
    @Override
    @NonNull
    default public AnnotationMetadata getAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    @Override
    default public boolean isEnabled(@NonNull BeanContext context, BeanResolutionContext resolutionContext) {
        return true;
    }

    @Override
    default public List<Argument<?>> getTypeArguments(Class<?> type) {
        Class beanType = this.getBeanType();
        if (type != null && type.isAssignableFrom(beanType)) {
            if (type.isInterface()) {
                return Arrays.stream(GenericTypeUtils.resolveInterfaceTypeArguments(beanType, type)).map(Argument::of).collect(Collectors.toList());
            }
            return Arrays.stream(GenericTypeUtils.resolveSuperTypeGenericArguments(beanType, type)).map(Argument::of).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    default public boolean isContextScope() {
        return this.getAnnotationMetadata().hasDeclaredAnnotation(Context.class);
    }

    @Override
    default public boolean isConfigurationProperties() {
        return BeanDefinitionReference.super.isConfigurationProperties();
    }

    @Override
    default public BeanDefinition<T> load() {
        return this;
    }

    @Override
    default public String getBeanDefinitionName() {
        return DefaultRuntimeBeanDefinition.generateBeanName(this.getBeanType());
    }

    @Override
    default public BeanDefinition<T> load(BeanContext context) {
        return this;
    }

    @Override
    default public boolean isPresent() {
        return true;
    }

    @Override
    default public boolean isSingleton() {
        return BeanDefinitionReference.super.isSingleton();
    }

    @NonNull
    public static <B> RuntimeBeanDefinition<B> of(@NonNull B bean) {
        Objects.requireNonNull(bean, "Bean cannot be null");
        Class<?> t2 = bean.getClass();
        return RuntimeBeanDefinition.builder(t2, () -> bean).singleton(true).build();
    }

    @NonNull
    public static <B> RuntimeBeanDefinition<B> of(@NonNull Class<B> beanType, @NonNull Supplier<B> beanSupplier) {
        return RuntimeBeanDefinition.builder(beanType, beanSupplier).build();
    }

    @NonNull
    public static <B> Builder<B> builder(@NonNull B bean) {
        Objects.requireNonNull(bean, "Bean cannot be null");
        Argument<?> beanType = Argument.of(bean.getClass());
        return new DefaultRuntimeBeanDefinition.RuntimeBeanBuilder<Object>(beanType, () -> bean).singleton(true);
    }

    @NonNull
    public static <B> Builder<B> builder(@NonNull Class<B> beanType, @NonNull Supplier<B> beanSupplier) {
        return new DefaultRuntimeBeanDefinition.RuntimeBeanBuilder<B>(Argument.of(beanType), beanSupplier);
    }

    @NonNull
    public static <B> Builder<B> builder(@NonNull Argument<B> beanType, @NonNull Supplier<B> beanSupplier) {
        return new DefaultRuntimeBeanDefinition.RuntimeBeanBuilder<B>(beanType, beanSupplier);
    }

    public static interface Builder<B> {
        @NonNull
        public Builder<B> qualifier(@Nullable Qualifier<B> var1);

        @NonNull
        public Builder<B> replaces(@Nullable Class<? extends B> var1);

        @NonNull
        default public Builder<B> named(@Nullable String name) {
            if (name == null) {
                this.qualifier(null);
            } else {
                this.qualifier(Qualifiers.byName(name));
            }
            return this;
        }

        @NonNull
        public Builder<B> scope(@Nullable Class<? extends Annotation> var1);

        @NonNull
        public Builder<B> singleton(boolean var1);

        @NonNull
        public Builder<B> exposedTypes(Class<?> ... var1);

        @NonNull
        public Builder<B> typeArguments(Argument<?> ... var1);

        @NonNull
        public Builder<B> typeArguments(Class<?> var1, Argument<?> ... var2);

        @NonNull
        public Builder<B> annotationMetadata(@Nullable AnnotationMetadata var1);

        @NonNull
        public RuntimeBeanDefinition<B> build();
    }
}

