/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.netty.util.ReferenceCountUtil;
import java.io.Closeable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public final class PublisherAsBlocking<T>
implements Subscriber<T>,
Closeable {
    private final Lock lock = new ReentrantLock();
    private final Condition newDataCondition = this.lock.newCondition();
    private boolean pendingDemand;
    private T swap;
    private Subscription subscription;
    private boolean done;
    private boolean closed;
    private Throwable failure;

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public void onSubscribe(Subscription s2) {
        boolean pendingDemand;
        this.lock.lock();
        try {
            this.subscription = s2;
            pendingDemand = this.pendingDemand;
        }
        finally {
            this.lock.unlock();
        }
        if (pendingDemand) {
            s2.request(1L);
        }
    }

    @Override
    public void onNext(T o) {
        this.lock.lock();
        try {
            if (this.closed) {
                ReferenceCountUtil.release(o);
                return;
            }
            this.swap = o;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.lock.lock();
        try {
            if (this.swap != null) {
                ReferenceCountUtil.release(this.swap);
                this.swap = null;
            }
            this.failure = t2;
            this.done = true;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onComplete() {
        this.lock.lock();
        try {
            this.done = true;
            this.newDataCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T take() throws InterruptedException {
        boolean demanded = false;
        while (true) {
            Subscription subscription;
            this.lock.lock();
            try {
                T swap = this.swap;
                if (swap != null) {
                    this.swap = null;
                    T t2 = swap;
                    return t2;
                }
                if (this.done) {
                    T t3 = null;
                    return t3;
                }
                if (demanded) {
                    this.newDataCondition.await();
                }
                if ((subscription = this.subscription) == null) {
                    this.pendingDemand = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (demanded) continue;
            demanded = true;
            if (subscription == null) continue;
            subscription.request(1L);
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.swap != null) {
                ReferenceCountUtil.release(this.swap);
                this.swap = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

