/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadata;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.EnvironmentAnnotationMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class DefaultAnnotationMetadata
extends AbstractAnnotationMetadata
implements AnnotationMetadata,
Cloneable,
EnvironmentAnnotationMetadata {
    @Nullable
    Map<String, Map<CharSequence, Object>> declaredAnnotations;
    @Nullable
    Map<String, Map<CharSequence, Object>> allAnnotations;
    @Nullable
    Map<String, Map<CharSequence, Object>> declaredStereotypes;
    @Nullable
    Map<String, Map<CharSequence, Object>> allStereotypes;
    @Nullable
    Map<String, List<String>> annotationsByStereotype;
    private final Map<String, List> annotationValuesByType = new ConcurrentHashMap<String, List>(2);
    private final boolean hasPropertyExpressions;
    private final boolean hasEvaluatedExpressions;

    @Internal
    protected DefaultAnnotationMetadata() {
        this.hasPropertyExpressions = false;
        this.hasEvaluatedExpressions = false;
    }

    @Internal
    public DefaultAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype) {
        this(declaredAnnotations, declaredStereotypes, allStereotypes, allAnnotations, annotationsByStereotype, true);
    }

    @Internal
    public DefaultAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype, boolean hasPropertyExpressions) {
        this(declaredAnnotations, declaredStereotypes, allStereotypes, allAnnotations, annotationsByStereotype, hasPropertyExpressions, false);
    }

    @Internal
    public DefaultAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype, boolean hasPropertyExpressions, boolean hasEvaluatedExpressions) {
        super(declaredAnnotations, allAnnotations);
        this.declaredAnnotations = declaredAnnotations;
        this.declaredStereotypes = declaredStereotypes;
        this.allStereotypes = allStereotypes;
        this.allAnnotations = allAnnotations;
        this.annotationsByStereotype = annotationsByStereotype;
        this.hasPropertyExpressions = hasPropertyExpressions;
        this.hasEvaluatedExpressions = hasEvaluatedExpressions;
    }

    @Override
    @NonNull
    public AnnotationMetadata getDeclaredMetadata() {
        return new DefaultAnnotationMetadata(this.declaredAnnotations, this.declaredStereotypes, null, null, this.annotationsByStereotype, this.hasPropertyExpressions);
    }

    @Override
    public boolean hasPropertyExpressions() {
        return this.hasPropertyExpressions;
    }

    @Override
    public boolean hasEvaluatedExpressions() {
        return this.hasEvaluatedExpressions;
    }

    @Override
    @NonNull
    public Map<CharSequence, Object> getDefaultValues(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return AnnotationMetadataSupport.getDefaultValues(annotation);
    }

    @Override
    public boolean isPresent(@NonNull String annotation, @NonNull String member) {
        if (this.allAnnotations == null || StringUtils.isEmpty(annotation)) {
            return false;
        }
        Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
        if (values != null) {
            return values.containsKey(member);
        }
        if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
            return values.containsKey(member);
        }
        return false;
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull String annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType, null);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValue(annotation, member, enumType, null);
    }

    @Override
    @Internal
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.enumValue(member, enumType, valueMapper);
            }
            return Optional.empty();
        }
        return this.enumValue(annotation.getName(), member, enumType, valueMapper);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull String annotation, Class<E> enumType) {
        return this.enumValues(annotation, "value", enumType, null);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValues(annotation, "value", enumType, null);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        return this.enumValues(annotation, member, enumType, null);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("enumType", enumType);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawValue(repeatableTypeName, member);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.enumValues(member, enumType);
            }
            return (Enum[])Array.newInstance(enumType, 0);
        }
        Object v = this.getRawValue(annotation.getName(), member);
        return AnnotationValue.resolveEnumValues(enumType, (Object)v);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("enumType", enumType);
        Object v = this.getRawValue(annotation, member);
        return AnnotationValue.resolveEnumValues(enumType, (Object)v);
    }

    @Override
    @Internal
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        return this.enumValueOf(enumType, rawValue);
    }

    private <E extends Enum<E>> Optional<E> enumValueOf(Class<E> enumType, Object rawValue) {
        if (rawValue != null) {
            if (enumType.isInstance(rawValue)) {
                return Optional.of((Enum)rawValue);
            }
            try {
                return Optional.of(Enum.valueOf(enumType, rawValue.toString()));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Object rawSingleValue = this.getRawValue(annotation, member);
        Class<?>[] classes = AnnotationValue.resolveClassValues(rawSingleValue);
        if (classes != null) {
            return classes;
        }
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    @Override
    public <T> Class<T>[] classValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, member, null);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                Class<?>[] classes = annotationValue.classValues(member);
                return classes;
            }
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        return this.classValues(annotation.getName(), member);
    }

    @Override
    @NonNull
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.classValue(annotation, member, null);
    }

    @Override
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, member, valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.classValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.classValue(annotation.getName(), member, valueMapper);
    }

    @Override
    @NonNull
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.classValue(annotation, member, null);
    }

    @Override
    @Internal
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof AnnotationClassValue) {
            AnnotationClassValue annotationClassValue = (AnnotationClassValue)rawValue;
            return annotationClassValue.getType();
        }
        if (rawValue instanceof Class) {
            Class class1 = (Class)rawValue;
            return Optional.of(class1);
        }
        if (rawValue != null) {
            return ConversionService.SHARED.convert(rawValue, Class.class);
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.intValue(annotation, member, null);
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.intValue(annotation, member, null);
    }

    @Override
    @Internal
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.intValue(member, valueMapper);
            }
            return OptionalInt.empty();
        }
        return this.intValue(annotation.getName(), member, valueMapper);
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.booleanValue(annotation, member, null);
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.booleanValue(annotation, member, null);
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", null);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.booleanValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.booleanValue(annotation.getName(), member, valueMapper);
    }

    @Override
    @NonNull
    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Boolean) {
            Boolean aBoolean = (Boolean)rawValue;
            return Optional.of(aBoolean);
        }
        if (rawValue != null) {
            return Optional.of(StringUtils.isTrue(rawValue.toString()));
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.longValue(annotation, member, null);
    }

    @Override
    @NonNull
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.longValue(annotation, member, null);
    }

    @Override
    @Internal
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.longValue(member, valueMapper);
            }
            return OptionalLong.empty();
        }
        return this.longValue(annotation.getName(), member, valueMapper);
    }

    @Override
    @NonNull
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        String str;
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            return OptionalLong.of(number.longValue());
        }
        if (rawValue instanceof CharSequence && StringUtils.isNotEmpty(str = rawValue.toString())) {
            try {
                long i = Long.parseLong(str);
                return OptionalLong.of(i);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value [" + str + "] of [" + member + "] of annotation [" + annotation + "]: " + e.getMessage(), e);
            }
        }
        return OptionalLong.empty();
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        String str;
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            return OptionalInt.of(number.intValue());
        }
        if (rawValue instanceof CharSequence && StringUtils.isNotEmpty(str = rawValue.toString())) {
            try {
                int i = Integer.parseInt(str);
                return OptionalInt.of(i);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value [" + str + "] of [" + member + "] of annotation [" + annotation + "]: " + e.getMessage(), e);
            }
        }
        return OptionalInt.empty();
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.stringValue(annotation, member, null);
    }

    @Override
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.stringValue(member, valueMapper);
            }
            return Optional.empty();
        }
        return this.stringValue(annotation.getName(), member, valueMapper);
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.stringValues(annotation.getName(), member, null);
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull String annotation, @NonNull String member) {
        return this.stringValues(annotation, member, null);
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawValue(repeatableTypeName, member);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.stringValues(member, valueMapper);
            }
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        Object v = this.getRawValue(annotation.getName(), member);
        String[] strings = AnnotationValue.resolveStringValues(v, valueMapper);
        return strings != null ? strings : StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull String annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        Object v = this.getRawValue(annotation, member);
        String[] strings = AnnotationValue.resolveStringValues(v, valueMapper);
        return strings != null ? strings : StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.stringValue(annotation, member, null);
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof String) {
            String s2 = (String)rawValue;
            return Optional.of(s2);
        }
        if (rawValue instanceof CharSequence) {
            return Optional.of(rawValue.toString());
        }
        if (rawValue instanceof Class) {
            Class aClass = (Class)rawValue;
            String name = aClass.getName();
            return Optional.of(name);
        }
        if (rawValue != null) {
            return Optional.of(rawValue.toString());
        }
        return Optional.empty();
    }

    @Override
    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.isTrue(annotation, member, null);
    }

    @Override
    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.isTrue(member, valueMapper);
            }
            return false;
        }
        return this.isTrue(annotation.getName(), member, valueMapper);
    }

    @Override
    public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.isTrue(annotation, member, null);
    }

    @Override
    public boolean isTrue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Boolean) {
            Boolean aBoolean = (Boolean)rawValue;
            return aBoolean;
        }
        if (rawValue != null) {
            String booleanString = rawValue.toString().toLowerCase(Locale.ENGLISH);
            return StringUtils.isTrue(booleanString);
        }
        return false;
    }

    @Override
    public boolean isFalse(@NonNull String annotation, @NonNull String member) {
        return !this.isTrue(annotation, member);
    }

    @Override
    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.doubleValue(annotation, member, null);
    }

    @Override
    @NonNull
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.doubleValue(annotation, member, null);
    }

    @Override
    @Internal
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            Object v = this.getRawSingleValue(repeatableTypeName, "value", valueMapper);
            if (v instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)v;
                return annotationValue.doubleValue(member, valueMapper);
            }
            return OptionalDouble.empty();
        }
        return this.doubleValue(annotation.getName(), member);
    }

    @Override
    @NonNull
    @Internal
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member, Function<Object, Object> valueMapper) {
        String str;
        Object rawValue = this.getRawSingleValue(annotation, member, valueMapper);
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            return OptionalDouble.of(number.doubleValue());
        }
        if (rawValue instanceof CharSequence && StringUtils.isNotEmpty(str = rawValue.toString())) {
            try {
                double i = Double.parseDouble(str);
                return OptionalDouble.of(i);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Invalid value [" + str + "] of member [" + member + "] of annotation [" + annotation + "]: " + e.getMessage(), e);
            }
        }
        return OptionalDouble.empty();
    }

    @Override
    @NonNull
    public <T> Optional<T> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation.getName());
        if (repeatableTypeName != null) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get(member, requiredType);
            }
            return Optional.empty();
        }
        return this.getValue(annotation.getName(), member, requiredType);
    }

    @Override
    @NonNull
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        return this.getValue(annotation, member, requiredType, null);
    }

    @Override
    @NonNull
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType, @Nullable Function<Object, Object> valueMapper) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Optional resolved = Optional.empty();
        if (this.allAnnotations != null && StringUtils.isNotEmpty(annotation)) {
            Object rawValue;
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                Object rawValue2 = values.get(member);
                if (rawValue2 != null) {
                    if (valueMapper != null) {
                        rawValue2 = valueMapper.apply(rawValue2);
                    }
                    resolved = ConversionService.SHARED.convert(rawValue2, requiredType);
                }
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null && (rawValue = values.get(member)) != null) {
                if (valueMapper != null) {
                    rawValue = valueMapper.apply(rawValue);
                }
                resolved = ConversionService.SHARED.convert(rawValue, requiredType);
            }
        }
        if (resolved.isEmpty() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return resolved;
    }

    @Override
    @NonNull
    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Map<CharSequence, Object> defaultValues = this.getDefaultValues(annotation);
        Object v = defaultValues.get(member);
        if (v == null) {
            return Optional.empty();
        }
        if (requiredType.isInstance(v)) {
            return Optional.of(v);
        }
        return ConversionService.SHARED.convert(v, requiredType);
    }

    @Override
    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nullable Class<T> annotationType) {
        if (annotationType == null) {
            return List.of();
        }
        String annotationTypeName = annotationType.getName();
        List<AnnotationValue<Object>> results = this.annotationValuesByType.get(annotationTypeName);
        if (results == null) {
            Map<CharSequence, Object> values;
            results = this.resolveAnnotationValuesByType(annotationType, this.allAnnotations, this.allStereotypes);
            if (results != null) {
                return results;
            }
            if (this.allAnnotations != null && (values = this.allAnnotations.get(annotationTypeName)) != null) {
                results = List.of(this.newAnnotationValue(annotationTypeName, values));
            }
            if (results == null) {
                results = List.of();
            }
            this.annotationValuesByType.put(annotationTypeName, results);
        }
        return results;
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByName(String annotationType) {
        Map<CharSequence, Object> values;
        if (annotationType == null) {
            return List.of();
        }
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotationType);
        if (repeatableTypeName == null) {
            return List.of();
        }
        List<AnnotationValue<Object>> results = this.resolveRepeatableAnnotations(repeatableTypeName, this.allAnnotations, this.allStereotypes);
        if (results != null) {
            return results;
        }
        if (this.allAnnotations != null && (values = this.allAnnotations.get(annotationType)) != null) {
            results = List.of(this.newAnnotationValue(annotationType, values));
        }
        if (results == null) {
            results = List.of();
        }
        this.annotationValuesByType.put(annotationType, results);
        return List.of();
    }

    @NonNull
    protected <T extends Annotation> AnnotationValue<T> newAnnotationValue(String annotationType, Map<CharSequence, Object> values) {
        return new AnnotationValue(annotationType, values, AnnotationMetadataSupport.getDefaultValuesOrNull(annotationType));
    }

    @Override
    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        if (annotationType == null) {
            return List.of();
        }
        List<AnnotationValue<T>> results = this.resolveAnnotationValuesByType(annotationType, this.declaredAnnotations, this.declaredStereotypes);
        if (results != null) {
            return results;
        }
        return List.of();
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByName(String annotationType) {
        if (annotationType == null) {
            return List.of();
        }
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotationType);
        List<AnnotationValue<T>> results = this.resolveRepeatableAnnotations(repeatableTypeName, this.declaredAnnotations, this.declaredStereotypes);
        if (results != null) {
            return results;
        }
        return List.of();
    }

    @Override
    public <T extends Annotation> T[] synthesizeAnnotationsByType(@NonNull Class<T> annotationClass) {
        if (annotationClass == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        return (Annotation[])this.getAnnotationValuesByType(annotationClass).stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, entries)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    @Override
    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@NonNull Class<T> annotationClass) {
        if (annotationClass == null) {
            return AnnotationUtil.ZERO_ANNOTATIONS;
        }
        return (Annotation[])this.getAnnotationValuesByType(annotationClass).stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, entries)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    @Override
    public boolean isEmpty() {
        return this.allAnnotations == null || this.allAnnotations.isEmpty();
    }

    @Override
    public boolean hasDeclaredAnnotation(String annotation) {
        return this.declaredAnnotations != null && StringUtils.isNotEmpty(annotation) && this.declaredAnnotations.containsKey(annotation);
    }

    @Override
    public boolean hasAnnotation(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.allAnnotations != null && StringUtils.isNotEmpty(annotation) && this.allAnnotations.containsKey(annotation);
    }

    @Override
    public boolean hasStereotype(String annotation) {
        return this.hasAnnotation(annotation) || this.allStereotypes != null && StringUtils.isNotEmpty(annotation) && this.allStereotypes.containsKey(annotation);
    }

    @Override
    public boolean hasDeclaredStereotype(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.declaredStereotypes != null && StringUtils.isNotEmpty(annotation) && this.declaredStereotypes.containsKey(annotation);
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return Optional.empty();
        }
        if (this.annotationsByStereotype != null && CollectionUtils.isNotEmpty(annotations = this.annotationsByStereotype.get(stereotype))) {
            return this.getAnnotationType(annotations.get(0));
        }
        if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
            return this.getAnnotationType(stereotype);
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return this.getAnnotationType(stereotype);
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Optional<String> getAnnotationNameByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return Optional.empty();
        }
        if (this.annotationsByStereotype != null && CollectionUtils.isNotEmpty(annotations = this.annotationsByStereotype.get(stereotype))) {
            return Optional.of(annotations.get(0));
        }
        if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
            return Optional.of(stereotype);
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return Optional.of(stereotype);
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return List.of();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            return Collections.unmodifiableList(annotations);
        }
        if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
            return List.of(stereotype);
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return List.of(stereotype);
        }
        return List.of();
    }

    @Override
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByStereotype(String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return List.of();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            ArrayList result = new ArrayList(annotations.size());
            for (String annotation : annotations) {
                String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotation);
                if (repeatableTypeName != null) {
                    List<AnnotationValue<T>> results = this.resolveRepeatableAnnotations(repeatableTypeName, this.allAnnotations, this.allStereotypes);
                    if (results == null) continue;
                    result.addAll(results);
                    continue;
                }
                result.add(this.getAnnotation(annotation));
            }
            return Collections.unmodifiableList(result);
        }
        if (this.allAnnotations != null) {
            return this.getAnnotationValuesByName(stereotype);
        }
        if (this.declaredAnnotations != null) {
            return this.getDeclaredAnnotationValuesByName(stereotype);
        }
        return List.of();
    }

    @Override
    @NonNull
    public Set<String> getAnnotationNames() {
        if (this.allAnnotations != null) {
            return Collections.unmodifiableSet(this.allAnnotations.keySet());
        }
        return Set.of();
    }

    @Override
    @NonNull
    public Set<String> getStereotypeAnnotationNames() {
        if (this.allStereotypes != null) {
            return Collections.unmodifiableSet(this.allStereotypes.keySet());
        }
        return Set.of();
    }

    @Override
    @NonNull
    public Set<String> getDeclaredStereotypeAnnotationNames() {
        if (this.declaredStereotypes != null) {
            return Collections.unmodifiableSet(this.declaredStereotypes.keySet());
        }
        return Set.of();
    }

    @Override
    @NonNull
    public Set<String> getDeclaredAnnotationNames() {
        if (this.declaredAnnotations != null) {
            return Collections.unmodifiableSet(this.declaredAnnotations.keySet());
        }
        return Set.of();
    }

    @Override
    @NonNull
    public List<String> getDeclaredAnnotationNamesByStereotype(@Nullable String stereotype) {
        List<String> annotations;
        if (stereotype == null) {
            return List.of();
        }
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            annotations = new ArrayList<String>(annotations);
            if (this.declaredAnnotations != null) {
                annotations.removeIf(s2 -> !this.declaredAnnotations.containsKey(s2));
                return Collections.unmodifiableList(annotations);
            }
            return List.of();
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return List.of(stereotype);
        }
        return List.of();
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name) {
        return AnnotationMetadataSupport.getAnnotationType(name);
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name, @NonNull ClassLoader classLoader) {
        return AnnotationMetadataSupport.getAnnotationType(name, classLoader);
    }

    @Override
    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        if (this.allAnnotations == null || StringUtils.isEmpty(annotation)) {
            return Optional.empty();
        }
        Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
        if (values != null) {
            return Optional.of(this.newAnnotationValue(annotation, values));
        }
        if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
            return Optional.of(this.newAnnotationValue(annotation, values));
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        if (this.declaredAnnotations == null || StringUtils.isEmpty(annotation)) {
            return Optional.empty();
        }
        Map<CharSequence, Object> values = this.declaredAnnotations.get(annotation);
        if (values != null) {
            return Optional.of(this.newAnnotationValue(annotation, values));
        }
        if (this.declaredStereotypes != null && (values = this.declaredStereotypes.get(annotation)) != null) {
            return Optional.of(this.newAnnotationValue(annotation, values));
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("valueType", valueType);
        if (this.allAnnotations == null || StringUtils.isEmpty(annotation)) {
            return OptionalValues.empty();
        }
        Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
        if (values != null) {
            return OptionalValues.of(valueType, values);
        }
        if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
            return OptionalValues.of(valueType, values);
        }
        return OptionalValues.empty();
    }

    @Override
    @NonNull
    public Map<CharSequence, Object> getValues(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        if (this.allAnnotations == null || StringUtils.isEmpty(annotation)) {
            return Collections.emptyMap();
        }
        Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
        if (values != null) {
            return Collections.unmodifiableMap(values);
        }
        if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
            return Collections.unmodifiableMap(values);
        }
        return Collections.emptyMap();
    }

    @Override
    @NonNull
    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Map<CharSequence, Object> defaultValues = this.getDefaultValues(annotation);
        Object value = defaultValues.get(member);
        if (value != null) {
            return ConversionService.SHARED.convert(value, requiredType);
        }
        return Optional.empty();
    }

    @Override
    public boolean isRepeatableAnnotation(Class<? extends Annotation> annotation) {
        return this.isRepeatableAnnotation(annotation.getName());
    }

    @Override
    public boolean isRepeatableAnnotation(String annotation) {
        return this.findRepeatableAnnotationContainerInternal(annotation) != null;
    }

    @Override
    public Optional<String> findRepeatableAnnotation(Class<? extends Annotation> annotation) {
        return this.findRepeatableAnnotation(annotation.getName());
    }

    @Override
    public Optional<String> findRepeatableAnnotation(String annotation) {
        return Optional.ofNullable(this.findRepeatableAnnotationContainerInternal(annotation));
    }

    @Override
    public AnnotationMetadata copyAnnotationMetadata() {
        return this.clone();
    }

    public DefaultAnnotationMetadata clone() {
        DefaultAnnotationMetadata cloned = new DefaultAnnotationMetadata(this.declaredAnnotations != null ? this.cloneMapOfMapValue(this.declaredAnnotations) : null, this.declaredStereotypes != null ? this.cloneMapOfMapValue(this.declaredStereotypes) : null, this.allStereotypes != null ? this.cloneMapOfMapValue(this.allStereotypes) : null, this.allAnnotations != null ? this.cloneMapOfMapValue(this.allAnnotations) : null, this.annotationsByStereotype != null ? this.cloneMapOfListValue(this.annotationsByStereotype) : null, this.hasPropertyExpressions);
        return cloned;
    }

    protected final <X, Y, K> Map<K, Map<X, Y>> cloneMapOfMapValue(Map<K, Map<X, Y>> toClone) {
        return toClone.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), this.cloneMap((Map)e.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (a, b) -> a, LinkedHashMap::new));
    }

    protected final <K, V> Map<K, List<V>> cloneMapOfListValue(Map<K, List<V>> toClone) {
        return toClone.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), new ArrayList((Collection)e.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (a, b) -> a, LinkedHashMap::new));
    }

    protected final <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        Map<K, V> newMap;
        if (map instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)map;
            newMap = (Map)linkedHashMap.clone();
        } else {
            newMap = new LinkedHashMap<K, V>(map);
        }
        for (Map.Entry entry : newMap.entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            LinkedHashSet newValue = new LinkedHashSet((Collection)entry.getValue());
            entry.setValue(newValue);
        }
        return new HashMap<K, V>(newMap);
    }

    @Internal
    public static void registerAnnotationDefaults(String annotation, Map<CharSequence, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    public static void registerAnnotationDefaults(AnnotationClassValue<?> annotation, Map<CharSequence, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    public static void registerAnnotationType(AnnotationClassValue<?> annotation) {
        AnnotationMetadataSupport.registerAnnotationType(annotation);
    }

    @Internal
    public static void registerRepeatableAnnotations(Map<String, String> repeatableAnnotations) {
        AnnotationMetadataSupport.registerRepeatableAnnotations(repeatableAnnotations);
    }

    @Internal
    void dump() {
        System.out.println("declaredAnnotations = " + this.declaredAnnotations);
        System.out.println("declaredStereotypes = " + this.declaredStereotypes);
        System.out.println("allAnnotations = " + this.allAnnotations);
        System.out.println("allStereotypes = " + this.allStereotypes);
        System.out.println("annotationsByStereotype = " + this.annotationsByStereotype);
    }

    private <T extends Annotation> List<AnnotationValue<T>> resolveAnnotationValuesByType(Class<T> annotationType, Map<String, Map<CharSequence, Object>> sourceAnnotations, Map<String, Map<CharSequence, Object>> sourceStereotypes) {
        String repeatableTypeName = this.findRepeatableAnnotationContainerInternal(annotationType.getName());
        if (repeatableTypeName != null) {
            return this.resolveRepeatableAnnotations(repeatableTypeName, sourceStereotypes, sourceAnnotations);
        }
        return null;
    }

    @Nullable
    private <T extends Annotation> List<AnnotationValue<T>> resolveRepeatableAnnotations(String repeatableTypeName, Map<String, Map<CharSequence, Object>> sourceStereotypes, Map<String, Map<CharSequence, Object>> sourceAnnotations) {
        Map<CharSequence, Object> values;
        if (!this.hasStereotype(repeatableTypeName)) {
            return null;
        }
        List<AnnotationValue<T>> results = null;
        if (sourceAnnotations != null) {
            values = sourceAnnotations.get(repeatableTypeName);
            results = this.collectResult(results, values);
        }
        if (sourceStereotypes != null) {
            values = sourceStereotypes.get(repeatableTypeName);
            results = this.collectResult(results, values);
        }
        return results == null ? List.of() : results;
    }

    @Nullable
    private Object getRawSingleValue(@NonNull String annotation, @NonNull String member, @Nullable Function<Object, Object> valueMapper) {
        Object rawValue = this.getRawValue(annotation, member);
        if (rawValue != null) {
            Iterable iterable;
            Iterator i;
            if (rawValue.getClass().isArray()) {
                int len = Array.getLength(rawValue);
                if (len > 0) {
                    rawValue = Array.get(rawValue, 0);
                }
            } else if (rawValue instanceof Iterable && (i = (iterable = (Iterable)rawValue).iterator()).hasNext()) {
                rawValue = i.next();
            }
        }
        if (valueMapper != null && rawValue instanceof CharSequence) {
            return valueMapper.apply(rawValue);
        }
        return rawValue;
    }

    @Nullable
    private Object getRawValue(@NonNull String annotation, @NonNull String member) {
        if (this.allAnnotations == null || StringUtils.isEmpty(annotation)) {
            return null;
        }
        Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
        if (values != null) {
            return values.get(member);
        }
        if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
            return values.get(member);
        }
        return null;
    }

    @Nullable
    protected String findRepeatableAnnotationContainerInternal(@NonNull String annotation) {
        return AnnotationMetadataSupport.getRepeatableAnnotation(annotation);
    }

    private <T extends Annotation> List<AnnotationValue<T>> collectResult(List<AnnotationValue<T>> results, Map<CharSequence, Object> values) {
        if (values != null) {
            Object v = values.get("value");
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] avs = (AnnotationValue[])v;
                List<AnnotationValue<T>> result = Arrays.asList(avs);
                if (results == null) {
                    return result;
                }
                return CollectionUtils.concat(results, result);
            }
            if (v instanceof Collection) {
                Collection c = (Collection)v;
                ArrayList<AnnotationValue<T>> result = new ArrayList<AnnotationValue<T>>(c.size());
                for (Object o : c) {
                    if (!(o instanceof AnnotationValue)) continue;
                    AnnotationValue av = (AnnotationValue)o;
                    result.add(av);
                }
                if (results == null) {
                    return result;
                }
                return CollectionUtils.concat(results, result);
            }
        }
        return results;
    }
}

