/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json.convert;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Internal
public final class LazyJsonNode
implements ReferenceCounted {
    private final Lock lock = new ReentrantLock();
    @Nullable
    private ByteBuffer<?> buffer;
    private int refCnt = 1;
    @Nullable
    private volatile JsonNode asNode;
    @Nullable
    private JsonSyntaxException syntaxException;

    public LazyJsonNode(@NonNull ByteBuffer<?> buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parse(JsonMapper mapper, Argument<T> type) throws IOException {
        this.lock.lock();
        if (this.asNode == null) {
            T t2;
            try {
                t2 = mapper.readValue(this.buffer(), type);
            }
            catch (JsonSyntaxException se) {
                this.syntaxException = se;
                this.discardBuffer();
                throw se;
            }
            return t2;
        }
        T t3 = mapper.readValueFromTree(this.asNode, type);
        return t3;
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isObject() throws JsonSyntaxException {
        JsonNode n = this.asNode;
        if (n != null) {
            return n.isObject();
        }
        this.lock.lock();
        try {
            n = this.asNode;
            if (n != null) {
                boolean bl = n.isObject();
                return bl;
            }
            if (this.syntaxException != null) {
                throw this.syntaxException;
            }
            ByteBuffer<?> buf = this.buffer();
            if (buf.readableBytes() == 0) {
                boolean bl = false;
                return bl;
            }
            byte b = buf.getByte(buf.readerIndex());
            if (b == 32 || b == 9 || b == 10 || b == 13 || b == -17) {
                throw new IllegalStateException("JSON input is not properly trimmed");
            }
            boolean bl = b == 123;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    JsonNode toJsonNode(JsonMapper mapper) throws IOException {
        if (this.asNode == null) {
            this.lock.lock();
            try {
                if (this.asNode == null) {
                    if (this.syntaxException != null) {
                        throw this.syntaxException;
                    }
                    this.asNode = this.parse(mapper, Argument.of(JsonNode.class));
                }
                this.discardBuffer();
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.asNode;
    }

    @Override
    public LazyJsonNode retain() {
        this.lock.lock();
        try {
            if (this.refCnt == 0) {
                throw new IllegalStateException("Already released");
            }
            ++this.refCnt;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    private ByteBuffer<?> buffer() {
        ByteBuffer<?> b = this.buffer;
        if (b == null) {
            throw new IllegalStateException("Buffer not available anymore");
        }
        return b;
    }

    @Override
    public boolean release() {
        this.lock.lock();
        try {
            if (this.refCnt == 0) {
                throw new IllegalStateException("Already released");
            }
            --this.refCnt;
            if (this.refCnt == 0) {
                this.discardBuffer();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Internal
    public void tryRelease() {
        this.lock.lock();
        try {
            if (this.refCnt != 0) {
                this.release();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void discardBuffer() {
        ByteBuffer<?> byteBuffer = this.buffer;
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)((Object)byteBuffer);
            rc.release();
        }
        this.buffer = null;
    }
}

